<?php
	// number
	$number_of_post = $data['number_of_post'];
	// sort
	$post_sorting = $data['post_sorting'];
	// order
	$post_ordering = $data['post_ordering'];
	// Title Limit
	$title_limit = $data['post_title_length'];	
			
	$args = array(
		'cat' => $category,
		'order' => $post_ordering,
		'posts_per_page' => $number_of_post,
	);
		
	if ( $post_sorting == 'view' ) {
		$args['orderby']  = 'meta_value_num';
		$args['meta_key'] = 'barta_views';
	} else {
		$args['orderby'] = $post_sorting;
	}
	
	$query = new WP_Query( $args );
	$temp = BartaTheme_Helper::wp_set_temp_query( $query );
	
	$i = 1;
	if ( $query->have_posts() ) { 	
		while ( $query->have_posts() ) {
		$query->the_post();
		$excerpt = wp_trim_words(get_the_excerpt(), 30, '');		
		$news_title = wp_trim_words( get_the_title(), $title_limit, '' );		
		$news_comment_num = number_format_i18n( get_comments_number() );
		if ( !empty( $data['post_date_format'] ) ) {
			if ( $data['post_date_format'] == 'global' ){
				$formatted_post_date = get_the_date(); 
			} else {
				$formatted_post_date = get_the_date( 'M d, Y' );
			}
		}
?>
	<?php if ( $i == 1 ) { ?>	
		<div class="col-lg-8 col-md-12">
			<div class="img-overlay-70 img-scale-animate mb-2">
			<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
				<a href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size1, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( $data['show_no_preview_img'] == 'yes') {
							
								if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size1 );
								} else {
									echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						}
					?>
				</a>
				<?php } ?>
				<div class="mask-content-lg">				
				<?php if ( $data['cat_display'] == 'yes' ) { ?> 
				<div class="topic-box-bottom-lg"><?php echo barta_sel_category_prepare( $category ); ?></div>
				<?php } ?>
					<div class="post-meta-light">
						<ul>
							<?php if ( $data['post_author'] == 'yes') { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
							<?php } ?>
							<?php if ( $data['post_date'] == 'yes' ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php esc_html_e( 'Latest Update:','barta' ); ?> <?php echo get_post_modified_time(get_option( 'date_format' ) .' '. get_option( 'time_format' ), false, null, true); ?></li>
							<?php } ?>							
							<?php if ( $data['post_comment'] == 'yes' ) { ?>
								<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
							<?php } ?>
						</ul>
					</div>
					<h2 class="title-medium-light"><a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a></h2>		
				</div>
			</div>
		</div>
	<?php } ?>
	<?php if ( $i == 2 ) { ?>	
	<div class="col-lg-4 col-md-12">
		<div class="col-12">
			<div class="row tab-space1">
	<?php } ?>
	<?php if ( $i > 1 ) { ?>		
		<div class="col-12">
			<div class="img-overlay-70 img-scale-animate mb-2">
				<div class="mask-content-sm">
					<?php if ( $data['cat_display'] == 'yes' ) { ?> 
					<div class="topic-box-bottom-lg"><?php echo barta_sel_category_prepare( $category ); ?></div>
					<?php } ?>
					<h3 class="title-medium-light">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h3>
				</div>
				<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
				<a href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size1, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( $data['show_no_preview_img'] == 'yes') {
							
								if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size1 );
								} else {
									echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						}
					?>
				</a>
				<?php } ?>
			</div>			
		</div>			
	<?php } ?>		
	<?php if ( $query->post_count == $i ) { ?>
			</div>
		</div>
	<?php } ?>		
	<?php $i++; } ?>
<?php } ?>
<?php BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>