<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;
use BartaTheme;
use BartaTheme_Helper;
use \WP_Query;

$thumb_size1 = 'barta-size2';
$thumb_size2 = 'barta-size1';
$thumb_size3 = 'barta-size7';

?>
<div class="box-default row tab-space1 <?php echo esc_attr( $template ); ?>">
	<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
		<div class="col-12 mb-25p">
			<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
				<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
			</div>
		</div>
	<?php } ?>
	<?php
		$number_of_post = $data['number_of_post'];
		$number_of_post_offset = $data['number_of_post_offset'];
		$p_ids = array();

		// build up the array
		foreach ( $data['posts_not_in'] as $p_idsn ) {
			$p_ids[] = $p_idsn['post_not_in'];
		}
		// sort
		$post_sorting = $data['post_sorting'];
		// order
		$post_ordering = $data['post_ordering'];
		// Title Limit
		$title_limit = $data['post_title_length'];
		// content limit
		$content_limit = $data['post_excerpt_length'];

		$i = 1;

	if ( $data['cat_num'] == 'multi' ) {
		// build up the array
		foreach ( $data['category_list'] as $cat ) {
			$cats[] = array(
				'cat_multi_box' => $cat['cat_multi_box'],
			);
		}

		if ( !empty( $cats ) ) {
		//category
		$category_number = count( $cats );
			foreach ( $cats as $cat ) {
			if ( $cat['cat_multi_box'] != 0 ) {

			$args = array(
				'cat' => $cat['cat_multi_box'],
				'order' => $post_ordering,
				'posts_per_page' => 1,
				'offset' 	 	 => $number_of_post_offset,
				'post__not_in'   => $p_ids
			);

			if ( $post_sorting == 'view' ) {
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'barta_views';
			} else {
				$args['orderby'] = $post_sorting;
			}

			$query = new WP_Query( $args );

			$temp = BartaTheme_Helper::wp_set_temp_query( $query );

			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
				$query->the_post();
				$excerpt = wp_trim_words(get_the_excerpt(), $content_limit, '');
				$news_title = wp_trim_words( get_the_title(), $title_limit, '' );
				$news_comment_num = number_format_i18n( get_comments_number() );
				if ( !empty( $data['post_date_format'] ) ) {
					if ( $data['post_date_format'] == 'global' ){
						$formatted_post_date = get_the_date();
					} else {
						$formatted_post_date = get_the_date( 'M d, Y' );
					}
				}
	?>
	<?php if ( $i == 1 ) { ?>
		<div class="col-lg-6 col-md-12">
			<div class="img-scale-animate mb-2">
			<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
				<a class="img-overlay-70" href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size1, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( $data['show_no_preview_img'] == 'yes') {

								if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size1 );
								} else {
									echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-598x487.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						}
					?>
				</a>
				<?php } ?>
				<div class="mask-content-lg">
				<?php if ( $data['cat_display'] == 'yes' ) { ?>
				<div class="topic-box-bottom-lg"><?php echo barta_sel_category_prepare( $cat['cat_multi_box'] ); ?></div>
				<?php } ?>
					<div class="post-meta-light">
						<ul>
							<?php if ( $data['post_author'] == 'yes') { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
							<?php } ?>
							<?php if ( $data['post_date'] == 'yes' ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?>
							<?php } ?>
							<?php if ( $data['post_comment'] == 'yes' ) { ?>
								<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
							<?php } ?>
						</ul>
					</div>
					<h2 class="title-medium-light">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h2>

				</div>
			</div>
		</div>
<?php } ?>
	<?php if ( $i == 2 ) { ?>
		<div class="col-lg-6 col-md-12">
			<div class="row tab-space1">
	<?php } ?>
	<?php if ( $i == 2 ) { ?>
		<div class="col-12">
			<div class="img-scale-animate mb-2">
				<div class="mask-content-sm">
					<?php if ( $data['cat_display'] == 'yes' ) { ?>
					<div class="topic-box-bottom-lg"><?php echo barta_sel_category_prepare( $cat['cat_multi_box'] ); ?></div>
					<?php } ?>
					<h3 class="title-medium-light">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h3>
				</div>
				<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
				<a class="img-overlay-70" href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size2, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( $data['show_no_preview_img'] == 'yes') {

								if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size2 );
								} else {
									echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						}
					?>
				</a>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
	<?php if ( $i > 2 ) { ?>
		<div class="col-sm-6 col-12">
			<div class="img-scale-animate small-img">
				<div class="mask-content-sm">
					<?php if ( $data['cat_display'] == 'yes' ) { ?>
					<div class="topic-box-bottom-lg"><?php echo barta_sel_category_prepare( $cat['cat_multi_box'] ); ?></div>
					<?php } ?>
					<h4 class="title-medium-light">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h4>
				</div>
				<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
				<a class="img-overlay-70" href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size3, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( $data['show_no_preview_img'] == 'yes') {

								if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
									echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size3 );
								} else {
									echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-556x346.jpg' ) . '" alt="'.get_the_title().'">';
								}
							}
						}
					?>
				</a>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
<?php } ?>
<?php } ?>
<?php BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>
		<?php if ( $category_number == $i ) { ?>
				</div>
		<?php } ?>
	<?php } ?>
<?php $i++; } ?>
<?php } ?>
</div>
<?php } else {
	include 'rt-news-box-single-1.php';
} ?>
</div>