<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;

use \WP_Query;

$thumb_size = 'full';


?>
<div class="single-default clearfix <?php echo $template; ?>">
	<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
		<div class="mb-25p">
			<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
				<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
			</div>
		</div>
	<?php } ?>
	<div class="single-wrap">
	<?php
		// category
		$post_ID = $data['single_post_id'];		
		$args = array(
			'p' => $post_ID,
			'post_status' => 'publish',
		);
		$title_limit = $data['post_title_length'];
		$content_limit = $data['post_excerpt_length'];
		$query = new WP_Query( $args );	
		$temp = BartaTheme_Helper::wp_set_temp_query( $query );
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
			$query->the_post();
			$news_title = wp_trim_words( get_the_title(), $title_limit, '' );
			$excerpt = wp_trim_words(get_the_excerpt(), $content_limit, '');
			$news_comment_num = number_format_i18n( get_comments_number() );
			if ( !empty( $data['post_date_format'] ) ) {
				if ( $data['post_date_format'] == 'global' ){
					$formatted_post_date = get_the_date(); 
				} else {
					$formatted_post_date = get_the_date( 'M d, Y' );
				}
			}
	?>
	<div class="img-overlay-70">
		<a href="<?php the_permalink(); ?>" class="img-opacity-hover">
			<?php
				if ( has_post_thumbnail() ){
					the_post_thumbnail( $thumb_size, ['class' => 'img-fluid m-auto display-block'] );
				}
				else {
					if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
						echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
					}
					else {
						echo '<img class="wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage.jpg' ) . '" alt="'.get_the_title().'">';
					}
				}
			?>
		</a>
		<div class="container banner-content-style1">
				<?php if ( $data['cat_display'] == 'yes' ) { ?> 
				<div class="topic-box-bottom-lg"><?php echo barta_category_prepare(); ?></div>
				<?php } ?>			
				<div class="post-meta-light">
					<ul>
						<?php if ( $data['post_author'] == 'yes') { ?>
							<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
						<?php } ?>
						<?php if ( $data['post_date'] == 'yes' ) { ?>
							<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
						<?php } ?>
						<?php if ( $data['post_comment'] == 'yes' ) { ?>
							<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
						<?php } ?>
					</ul>
				</div>
			<h2 class="title-medium-light">
				<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
			</h2>
			<?php if ( $data['content_display'] == 'yes'){ ?>
				<P><?php echo wp_kses_post( $excerpt ); ?></p>
			<?php } ?>
		</div>
	</div>
	<?php } ?>
<?php } ?>
<?php BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>
	</div>
</div>