<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;
 
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Scheme_Base;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_News_Box extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT News Box', 'barta-core' );
		$this->rt_base = 'rt-news-box';
		parent::__construct( $data, $args );
	}
	
	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		
		$fields = array (
		
			/*News Box Style*/
			array (
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'News Box Style', 'barta-core' ),
			),
			/*Box style option*/
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout_box',
				'label'   => __( 'Box Layout Style', 'barta-core' ),
				'options' => array(					
					'box1' => __( '1.One Big Leading, 2 col, Content Inside, No Space', 'barta-core' ), // done
					'box2' => __( '2.One Big Leading, 2 col, Content Inside, With Space', 'barta-core' ), // done
					'box3' => __( '3.One Big Middle, 3 col, Content Inside', 'barta-core' ),					
					'box4' => __( '4.One Big, One Medium, 2 small', 'barta-core' ),					
					'box5' => __( '5. One Big Top, 1 col, List Style', 'barta-core' ),	
					'box6' => __( '6.One Big Left, 2 col, Boxed List', 'barta-core' ), //--
					'box7' => __( '7.One Big Left, 2 col, Boxed List, Content Inside', 'barta-core' ),
					'box8' => __( '8.One Big Left, 3 col(Equal), 5 item', 'barta-core' ), // going
					'box9' => __( '9.One Big Left, 3 col(Non-Equal)', 'barta-core' ), // going
					'box10' => __( '10. One Big, Two Medium, 2 col', 'barta-core' ),  // done
					'box11' => __( '11. One Big Top, 1 col, List Style content', 'barta-core' ),
					'box13' => __( '13. One Big Top, 1 col, List Style', 'barta-core' ),
				),
				'default' => 'box1',				
			),
			/*box title*/
			array (
				'label'			=> esc_html__( 'Show Title', 'barta-core' ),
				'type'  		=> Controls_Manager::SWITCHER,
				'id'			=> 'has_sec_title',
				'label_on'		=> esc_html__( 'Show', 'barta-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'barta-core' ),
				'return_value'	=> 'yes',
				'default'		=> 'yes',				
			),
			array (
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'News',
				'condition' => array( 'has_sec_title' => array( 'yes' ) ),
			),			
			/*Title Style Option*/
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'title_style',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'style_2' => __( 'style 1', 'barta-core' ),
					'style_1' => __( 'Style 2' , 'barta-core' ),
				),
				'default' => 'style_2',
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => __( 'Title Background Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title.style_2' => 'background: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_2 .titleinner' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-box-title-holder' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1 .titleinner' => 'border-top-color: {{VALUE}}',
				),
			),
			/*single or Multi category display option - switch*/
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat_num',
				'label'   => __( 'Single or Multiple<br>category Select', 'barta-core' ),
				'options' => array(
					'multi' 	=> __( 'Multiple Category', 'barta-core' ),
					'single'	=> __( 'Single Category', 'barta-core' ),
				),
				'default' => 'multi',
				'condition' => array( 'layout_box' => array( 'box1', 'box2', 'box3', 'box4', 'box6', 'box7', 'box8', 'box9', 'box10' ,'box11' ) ),
			),
			/*category select( Box Single )*/
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_single_box',
				'label'     => __( 'Categories', 'barta-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
				'condition' => array( 'cat_num' => array( 'single' ) ),
			),						
			/*category select( box Multi )*/
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'category_list',
				'label'   => __( 'Add as many Categories as you want', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::SELECT2,
						'name'    => 'cat_multi_box',
						'label'   => __( 'Categories', 'barta-core' ),
						'options' => $category_dropdown,
						'multiple'=> false,
						'default' => '1',
					),
				),
				'condition' => array( 'cat_num' => array( 'multi' ) ),
			),
			/*Featured Item title Style*/
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'      => 'feature_item_title_typo',
				'label'   => __( 'Featured Item title Style', 'barta-core' ),
				'selector' => '{{WRAPPER}} .box-default .title-medium-light',
			),			
			/*Small Item title Style*/
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'      => 'small_item_title_typo',
				'label'   => __( 'Small Item title Style', 'barta-core' ),
				'selector' => '{{WRAPPER}} .box-default h3',
			),			
			/*Title Style Option*/
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'small_item_style',
				'label'   => __( 'Small Item Style', 'barta-core' ),
				'options' => array(
					'general' => __( 'General' , 'barta-core' ),
					'boxed' => __( 'Boxed', 'barta-core' ),
				),
				'default' => 'general',
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'small_item_background',
				'label'   => __( 'Small Item Background Color', 'barta-core' ),
				'default' => false,
				'selectors' => array( 
					'{{WRAPPER}} .box-default .media.boxed' => 'background: {{VALUE}}',
				),
				'condition' => array( 'small_item_style' => array( 'boxed' ) ),
			),
			/*Small Item Image display option - switch*/
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'small_item_img_display',
				'label'       => __( 'Small Item img display', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			), 
			/*category display option - switch*/
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => __( 'Category Name Display', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			), 		
			/*category display option - switch*/
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'small_cat_display',
				'label'       => __( 'Category Name Display on Small Item', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Number of post - With dependancy*/
			array (
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post',
				'label'   => __( 'Number of Post', 'barta-core' ),
				'default' => '4',
				'condition' => array( 'cat_num' => array( 'single' ) ),
			),
			/*version 1.3*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post_offset',
				'label'   => __( 'Number of Post Offset', 'barta-core' ),
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => __( 'Enter Post ID that will not display', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => __( 'Post ID', 'barta-core' ),
						'default' => '0',
					),
				),
			),
			/*For Big Item*/
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => __( 'News Title Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .box-default h2 a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color_hover',
				'label'   => __( 'News Title Hover Color', 'barta-core' ),
				'default' => '#E53935',
				'selectors' => array(
					'{{WRAPPER}} .box-default h2 a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box-default .post-meta-dark ul li a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box-default .post-meta-light ul li a:hover' => 'color: {{VALUE}}',
				),
			),
			/*For Small Item*/
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'small_item_title_color',
				'label'   => __( 'Small Item Title Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .box-default h3 a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box-default h4 a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'small_item_title_color_hover',
				'label'   => __( 'Small Item Title Hover Color', 'barta-core' ),
				'default' => '#e53935',
				'selectors' => array(
					'{{WRAPPER}} .box-default h3 a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box-default h4 a:hover' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_date_color_dark',
				'label'   => __( 'News Date Color( Dark )', 'barta-core' ),
				'default' => '#757272',
				'selectors' => array(
					'{{WRAPPER}} .box-default .post-meta-dark' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box-default .post-meta-dark ul li a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_date_color_light',
				'label'   => __( 'News Date Color( Light )', 'barta-core' ),
				'default' => '#cccccc',
				'selectors' => array(
					'{{WRAPPER}} .box-default .post-meta-light ul li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .box-default .post-meta-light ul li a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_content_color',
				'label'   => __( 'News Content Color', 'barta-core' ),
				'default' => '#cccccc',
				'selectors' => array(
					'{{WRAPPER}} .box-default.rt-news-box-7 .media .media-body p' => 'color: {{VALUE}}',					
				),
				'condition' => array( 'layout_box' => array( 'box7' ) ),
			),			
			
			array(
				'mode' => 'section_end',
			),
			/*Common Post Display & Query Options*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => __( 'Common Post Display & Query Options', 'barta-core' ),
			),
			/*Post Sorting*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_sorting',
				'label'   => __( 'Post Sorting', 'barta-core' ),
				'options' => array(
					'recent' 		=> __( 'Recent Post', 'barta-core' ),
					'rand' 			=> __( 'Random Post', 'barta-core' ),
					'modified' 		=> __( 'Last Modified Post', 'barta-core' ),
					'comment_count' => __( 'Most commented Post', 'barta-core' ),
					'view' 			=> __( 'Most viewed Post', 'barta-core' ),
				),
				'default' => 'recent',
				//'condition' => array( 'layout_box' => array( 'box7' ) ),
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => __( 'Post Ordering', 'barta-core' ),
				'options' => array(
					'DESC'	=> __( 'Desecending', 'barta-core' ),
					'ASC'	=> __( 'Ascending', 'barta-core' ),
				),
				'default' => 'des',
			),
			/*Pagination - with dependancy*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'pagination_display',
				'label'       => __( 'Display Category Page', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'no',
				'condition' => array( 'layout_box' => array( 'box13' ) ),
			),
			/*Post Title Length*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_title_length',
				'label'   => __( 'Post Title Length - blank means no limit', 'barta-core' ),
				'default' => '6',
			),
			/*Post Excerpt Lenght*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_excerpt_length',
				'label'   => __( 'Post Excerpt Length - blank means no limit', 'barta-core' ),
				'default' => '10',
			),
			array(				
				'id'  	=> 'hr',
				'type'	=> Controls_Manager::DIVIDER,				
				'style' => 'thick',
			),
			/*Display Post Date*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_date',
				'label'       => __( 'Display Post Date', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),			
			/*Display Post Date Format*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_date_format',
				'label'   => __( 'Post Date Format', 'barta-core' ),
				'options' => array(
					'global' 		=> __( 'Wordpress Setting Format', 'barta-core' ),
					'custom' 		=> __( 'Customized', 'barta-core' ),
				),
				'default' => 'global',
			),
			/*Display Post Comment*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_comment',
				'label'       => __( 'Show Comment', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'no',
			),

			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_readmore',
				'label'       => __( 'Display Read more', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
			),	

			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_author',
				'label'       => __( 'Show Author Name', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),			
			/*Hide Thumbnail*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_post_thumb',
				'label'       => __( 'Display Post Thumbnail', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),
			
			/*Show No Preview image*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_no_preview_img',
				'label'       => __( 'Show No Preview Image', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),			
			array(
				'mode' => 'section_end',
			),
			/*Background otions*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_bacground',
				'label'   => __( 'Background For the Element Section', 'barta-core' ),
			),
			
			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'section_bg',
				'label'       => __( 'Show Author Name', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Background::get_type(),
				'name'      => 'section_item_background',
				'label'   => __( 'Section Item Background', 'barta-core' ),
				'selector' => '{{WRAPPER}} .box-default',
				'condition' => array( 'section_bg' => array( 'yes' ) ),
			),			
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Background::get_type(),
				'name'      => 'section_item_background_hover',
				'label'   => __( 'Section Item Background Hover', 'barta-core' ),
				'selector' => '{{WRAPPER}} .box-default',
				'condition' => array( 'section_bg' => array( 'no' ) ),
			),
			
			array(
				'mode' => 'section_end',
			),
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

			switch ( $data['layout_box'] ) {
				case 'box13':
				$template = 'rt-news-box-13';
				break;
				case 'box11':
				$template = 'rt-news-box-11';
				break;
				case 'box10':
				$template = 'rt-news-box-10';
				break;
				case 'box9':
				$template = 'rt-news-box-9';
				break;
				case 'box8':
				$template = 'rt-news-box-8';
				break;
				case 'box7':
				$template = 'rt-news-box-7';
				break;
				case 'box6':
				$template = 'rt-news-box-6';
				break;
				case 'box5':
				$data['cat_num'] = 'single';				
				$template = 'rt-news-box-5';
				break;
				case 'box4':
				$template = 'rt-news-box-4';
				break;
				case 'box3':
				$template = 'rt-news-box-3';
				break;
				case 'box2':
				$template = 'rt-news-box-2';
				break;
				default:
				$template = 'rt-news-box-1';
				break;
			}

		return $this->rt_template( $template, $data );
	}
}