<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Barta_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Base;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_News_Single extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Single News ', 'barta-core' );
		$this->rt_base = 'rt-single-news';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}		
		
		$fields = array(		
		
			/*News Box Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'News Box Style', 'barta-core' ),
			),
			/*Number of post - With dependancy*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'single_post_id',
				'label'   => __( 'Post ID', 'barta-core' ),
				'default' => '1',
			),
			/*box title*/
			array(
				'label'			=> esc_html__( 'Show Title', 'barta-core' ),
				'type'  		=> Controls_Manager::SWITCHER,
				'id'			=> 'has_sec_title',
				'label_on'		=> esc_html__( 'Show', 'barta-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'barta-core' ),
				'return_value'	=> 'yes',
				'default'		=> 'yes',				
			),					
			/*Title Style Option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'title_style',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'style_2' => __( 'Style 1' , 'barta-core' ),
					'style_1' => __( 'Style 2', 'barta-core' ),
				),
				'default' => 'style_2',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'News',
				'condition' => array( 'has_sec_title' => array( 'yes' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => __( 'Title Background Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .el-rt-news-box-title.style_2' => 'background: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_2 .titleinner' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-box-title-holder' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1 .titleinner' => 'border-top-color: {{VALUE}}',
				),
			),
			/*category display option - switch*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => __( 'Category Name Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*For Small Item*/
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'      => 'item_title_typo',
				'label'   => __( 'Item title Style', 'barta-core' ),
				'selector' => '{{WRAPPER}} .single-default .title-medium-light',
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => __( 'Title Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .single-default .title-medium-light a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color_hover',
				'label'   => __( 'Title Hover Color', 'barta-core' ),
				'default' => '#e53935',
				'selectors' => array(
					'{{WRAPPER}} .single-default .title-medium-light a:hover' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_color',
				'label'   => __( 'Post Meta Color', 'barta-core' ),
				'default' => '#cccccc',
				'selectors' => array(
					'{{WRAPPER}} .single-default .post-meta-light' => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-default .post-meta-light ul li a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => __( 'Content Color', 'barta-core' ),
				'default' => '#cccccc',
				'selectors' => array(
					'{{WRAPPER}} .rt-single-news .banner-content-style1 p' => 'color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			/*Common Post Display & Query Options*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => __( 'Common Post Display & Query Options', 'barta-core' ),
			),
			array(
				'type' => Controls_Manager::URL,			
				'label' => __( 'Link', 'barta-core' ),
				'id'      => 'URL',				
				'placeholder' => __( 'https://your-link.com', 'barta-core' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],	
			),
			/*Post Title Length*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_title_length',
				'label'   => __( 'Post Title Length - blank means no limit', 'barta-core' ),
				'default' => '10',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'content_display',
				'label'       => __( 'Show content Display', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'off',
			),	
			/*Post Excerpt Lenght*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_excerpt_length',
				'label'   => __( 'Post Excerpt Length - blank means no limit', 'barta-core' ),
				'default' => '10',
			),
			array(				
				'id'  	=> 'hr',
				'type'	=> Controls_Manager::DIVIDER,				
				'style' => 'thick',
			),
			/*Display Post Date*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_date',
				'label'       => __( 'Display Post Date', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),			
			/*Display Post Date Format*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_date_format',
				'label'   => __( 'Post Date Format', 'barta-core' ),
				'options' => array(
					'global' 		=> __( 'Wordpress Setting Format', 'barta-core' ),
					'custom' 		=> __( 'Customized', 'barta-core' ),
				),
				'default' => 'global',
			),
			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_author',
				'label'       => __( 'Display Author Name', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Display Post Comment*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_comment',
				'label'       => __( 'Display Comment Number', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Hide Thumbnail*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_post_thumb',
				'label'       => __( 'Display Post Thumbnail', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'hide', 'barta-core' ),
				'default'     => 'yes',
			),
			
			/*Show No Preview image*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_no_preview_img',
				'label'       => __( 'Show No Preview Image', 'barta-core' ),
				'label_on'    => __( 'Show', 'barta-core' ),
				'label_off'   => __( 'Hide', 'barta-core' ),
				'default'     => 'yes',
			),			
			array(
				'mode' => 'section_end',
			),
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		
		$template = 'rt-single-news';

		return $this->rt_template( $template, $data );
	}
}