<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;


if ( ! defined( 'ABSPATH' ) ) exit;

class Ticker extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Ticker', 'barta-core' );
		$this->rt_base = 'rt-ticker';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
	}

	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );
		
		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'barta-core' ),
			),
			array (
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => __( 'Top News', 'barta-core' ),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'tcker_title_color',
				'label'   => __( 'Ticker Title Color', 'barta-core' ),
				'default' => '#FFFFFF',
				'selectors' => array(
					'{{WRAPPER}} .bn-label.ticker-title' => 'color: {{VALUE}}',
				),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'tcker_bg_color',
				'label'   => __( 'Ticker Title Background color', 'barta-core' ),
				'default' => '#e53935',
				'selectors' => array(
					'{{WRAPPER}} .bn-label.ticker-title' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .ticker-title .boltu-right' => 'border-top-color: {{VALUE}}',					
					'{{WRAPPER}} .breaking-news-ticker' => 'border-color: {{VALUE}}',
				),
			),						
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'time_delay',
				'label'   => esc_html__( 'Ticker Delay', 'barta-core' ),
				'default' => '3500',
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tcker_style',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'scroll' => __( 'Scroll' , 'barta-core' ),
					'fade'   => __( 'Fade', 'barta-core' ),
					'slide-down'   => __( 'Slide Down', 'barta-core' ),
					'slide-up'   => __( 'Slide Up', 'barta-core' ),
					'slide-right'   => __( 'Slide Right', 'barta-core' ),
					'slide-left'   => __( 'Slide Left', 'barta-core' ),
					'typography'   => __( 'Typography', 'barta-core' ),
				),
				'default' => 'scroll',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'    => 'tcker_scrollspeed',
				'label'   => esc_html__( 'Scroll Speed', 'barta-core' ),
				'default' => '2',
				'condition' => array( 'tcker_style' => array( 'scroll' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tcker_direction',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'ltr' => __( 'Left To Right' , 'barta-core' ),
					'rtl' => __( 'Right to left', 'barta-core' ),
				),
				'default' => 'ltr',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'tcker_radius',
				'label'   => __( 'Ticker Radius', 'barta-core' ),
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'tcker_border',
				'label'   => __( 'Ticker Border', 'barta-core' ),
				'default' => '1',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'tcker_height',
				'label'   => __( 'Ticker Height', 'barta-core' ),
				'default' => '50',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tcker_stoponhover',
				'label'   => __( 'Stop On Hover', 'barta-core' ),
				'options' => array(
					'!0' => __( 'Active' , 'barta-core' ),
					'0' => __( 'Deactive', 'barta-core' ),
				),
				'default' => '!0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tcker_position',
				'label'   => __( 'Ticker Position', 'barta-core' ),
				'options' => array(
					'auto' 		   => __( 'Auto' , 'barta-core' ),
					'fixed-bottom' => __( 'Fixed Bottom', 'barta-core' ),
				),
				'default' => 'auto',
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tcker_control',
				'label'   => __( 'Ticker Control', 'barta-core' ),
				'options' => array(
					'show' => __( 'Show' , 'barta-core' ),
					'hide' => __( 'Hide', 'barta-core' ),
				),
				'default' => 'hide',
			),
			array(
				'mode' => 'section_end',
			),
					
			/*Post option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => __( 'Common Post Display & Query Options', 'barta-core' ),
			),
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'selectpostshow',
				'label'   => __( 'Selected Post<br>/ Category wise Post', 'barta-core' ),
				'options' => array(
					'selectedpost'	=> __( 'Selected Post', 'barta-core' ),
					'categorypost' 	=> __( 'Category wise Post', 'barta-core' ),
				),
				'default' => 'selectedpost',
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'category_list',
				'label'   => __( 'Add as many Categories as you want', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::SELECT2,
						'name'    => 'cat_multi_grid',
						'label'   => __( 'Categories', 'barta-core' ),
						'options' => $category_dropdown,
						'multiple'=> false,
						'default' => '1',
					),
				),
				'condition' => array( 'selectpostshow' => array( 'categorypost' ) ),
			),			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post',
				'label'   => __( 'Number of Post', 'barta-core' ),
				'default' => '3',
				'condition' => array( 'selectpostshow' => array( 'categorypost' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post_offset',
				'label'   => __( 'Number of Post Offset', 'barta-core' ),
				'default' => '0',
				'condition' => array( 'selectpostshow' => array( 'categorypost' ) ),
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => __( 'Enter Post ID that will not display', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => __( 'Post ID', 'barta-core' ),
						'default' => '0',
					),
				),
				'condition' => array( 'selectpostshow' => array( 'categorypost' ) ),
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'post_to_show',
				'label'   => __( 'Enter Post ID that will only display', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'selected_post_ids',
						'label'   => __( 'Post ID', 'barta-core' ),
						'default' => '0',
					),
				),
				'condition' => array( 'selectpostshow' => array( 'selectedpost' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_sorting',
				'label'   => __( 'Post Sorting', 'barta-core' ),
				'options' => array(
					'recent' 		=> __( 'Recent Post', 'barta-core' ),
					'rand' 			=> __( 'Random Post', 'barta-core' ),
					'modified' 		=> __( 'Last Modified Post', 'barta-core' ),
					'comment_count' => __( 'Most commented Post', 'barta-core' ),
					'view' 			=> __( 'Most viewed Post', 'barta-core' ),
				),
				'default' => 'recent',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => __( 'Post Ordering', 'barta-core' ),
				'options' => array(
					'DESC'	=> __( 'Desecending', 'barta-core' ),
					'ASC'	=> __( 'Ascending', 'barta-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$this->rt_load_scripts();

		$template = 'rt-ticker';

		return $this->rt_template( $template, $data );
	}
}