<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Testimonial extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Testimonial', 'barta-core' );
		$this->rt_base = 'rt-testimonial';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => __( '1 Col', 'barta-core' ),
				'6'  => __( '2 Col', 'barta-core' ),
				'4'  => __( '3 Col', 'barta-core' ),
				'3'  => __( '4 Col', 'barta-core' ),
				'2'  => __( '6 Col', 'barta-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style(  'owl-carousel' );
		wp_enqueue_style(  'owl-theme-default' );
		wp_enqueue_script( 'owl-carousel' );
	}

	public function rt_fields(){
		$cpt = BARTA_CORE_CPT_PREFIX;
		$terms  = get_terms( array( 'taxonomy' => "{$cpt}_testimonial_category", 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => __( 'Style', 'barta-core' ),
				'options' => array(
					'style1' => __( 'Style 1', 'barta-core' ),
					'style2' => __( 'Style 2', 'barta-core' ),
					'style3' => __( 'Style 3', 'barta-core' ),
					'style4' => __( 'Style 4 - Sidebar', 'barta-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'theme',
				'label'   => __( 'Theme', 'barta-core' ),
				'options' => array(
					'light' => __( 'Light Background', 'barta-core' ),
					'dark'  => __( 'Dark Background', 'barta-core' ),
				),
				'default' => 'light',
				'condition'   => array( 'style' => array( 'style1', 'style2', 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'Lorem Ipsum',
				'condition'   => array( 'style' => array( 'style4' ) ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => __( 'Word count', 'barta-core' ),
				'default' => 10,
				'description' => __( 'Maximum number of words', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => __( 'Total number of items', 'barta-core' ),
				'default' => 5,
				'description' => __( 'Write -1 to show all', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => __( 'Categories', 'barta-core' ),
				'options' => $category_dropdown,
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => __( 'Order By', 'barta-core' ),
				'options' => array(
					'date'        => __( 'Date (Recents comes first)', 'barta-core' ),
					'title'       => __( 'Title', 'barta-core' ),
					'menu_order'  => __( 'Custom Order (Available via Order field inside Page Attributes box)', 'barta-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'designation_display',
				'label'       => __( 'Designation Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Show or Hide Designation. Default: On', 'barta-core' ),
			),
			array(
				'mode' => 'section_end',
			),
			
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => __( 'Number of Responsive Columns', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => __( 'Desktops: > 1199px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => __( 'Desktops: > 991px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => __( 'Tablets: > 767px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => __( 'Phones: < 768px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => __( 'Small Phones: < 480px', 'barta-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),

			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => __( 'Slider Options', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_nav',
				'label'       => __( 'Navigation Arrow', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Enable or disable navigation arrow. Default: On', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_dots',
				'label'       => __( 'Navigation Dots', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => '',
				'description' => __( 'Enable or disable navigation dots. Default: Off', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => __( 'Autoplay', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Enable or disable autoplay. Default: On', 'barta-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => __( 'Stop on Hover', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Stop autoplay on mouse hover. Default: On', 'barta-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'slider_interval',
				'label'   => __( 'Autoplay Interval', 'barta-core' ),
				'options' => array(
					'5000' => __( '5 Seconds', 'barta-core' ),
					'4000' => __( '4 Seconds', 'barta-core' ),
					'3000' => __( '3 Seconds', 'barta-core' ),
					'2000' => __( '2 Seconds', 'barta-core' ),
					'1000' => __( '1 Second',  'barta-core' ),
				),
				'default' => '5000',
				'description' => __( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'barta-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => __( 'Autoplay Slide Speed', 'barta-core' ),
				'default' => 200,
				'description' => __( 'Slide speed in milliseconds. Default: 200', 'barta-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => __( 'Loop', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'description' => __( 'Loop to first item. Default: On', 'barta-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$owl_data = array( 
			'nav'                => $data['slider_nav'] == 'yes' ? true : false,
			'dots'               => $data['slider_dots'] == 'yes' ? true : false,
			'navText'            => array( "<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>" ),
			'autoplay'           => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplayTimeout'    => $data['slider_interval'],
			'autoplaySpeed'      => $data['slider_autoplay_speed'],
			'autoplayHoverPause' => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'               => $data['slider_loop'] == 'yes' ? true : false,
			'margin'             => 30,
			'responsive'         => array(
				'0'    => array( 'items' => 12 / $data['col_mobile'] ),
				'480'  => array( 'items' => 12 / $data['col_xs'] ),
				'768'  => array( 'items' => 12 / $data['col_sm'] ),
				'992'  => array( 'items' => 12 / $data['col_md'] ),
				'1200' => array( 'items' => 12 / $data['col_lg'] ),
			)
		);

		switch ( $data['style'] ) {
			case 'style2':
			$template = 'testimonial-2';
			break;
			case 'style3':
			$owl_data['margin'] = 0;
			$template = 'testimonial-3';
			break;
			case 'style4':
			$template = 'testimonial-4';
			break;
			default:
			$template = 'testimonial-1';
			break;
		}

		$data['owl_data'] = json_encode( $owl_data );
		$this->rt_load_scripts();

		return $this->rt_template( $template, $data );
	}
}