<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;
use \RT_Postmeta;


if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'RT_Postmeta' ) ) {
	return;
}

$Postmeta = RT_Postmeta::getInstance();

$prefix = BARTA_CORE_CPT_PREFIX;

/*-------------------------------------
#. Layout Settings
---------------------------------------*/
$nav_menus = wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus = array( 'default' => __( 'Default', 'barta-core' ) ) + $nav_menus;
$sidebars  = array( 'default' => __( 'Default', 'barta-core' ) ) + BartaTheme_Helper::custom_sidebar_fields();

$Postmeta->add_meta_box( "{$prefix}_page_settings", __( 'Layout Settings', 'barta-core' ), array( 'page', 'post' ), '', '', 'high', array(
	'fields' => array(
	
		"{$prefix}_layout" => array(
			'label'   => __( 'Layout', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default'       => __( 'Default', 'barta-core' ),
				'full-width'    => __( 'Full Width', 'barta-core' ),
				'left-sidebar'  => __( 'Left Sidebar', 'barta-core' ),
				'right-sidebar' => __( 'Right Sidebar', 'barta-core' ),
			),
			'default'  => 'default',
		),		
		'barta_sidebar' => array(
			'label'    => __( 'Custom Sidebar', 'barta-core' ),
			'type'     => 'select',
			'options'  => $sidebars,
			'default'  => 'default',
		),
		"{$prefix}_page_menu" => array(
			'label'    => __( 'Main Menu', 'barta-core' ),
			'type'     => 'select',
			'options'  => $nav_menus,
			'default'  => 'default',
		),
		"{$prefix}_tr_header" => array(
			'label'    	  => __( 'Transparent Header', 'barta-core' ),
			'type'     	  => 'select',
			'options'  	  => array(
				'default' => __( 'Default', 'barta-core' ),
				'on'      => __( 'Enabled', 'barta-core' ),
				'off'     => __( 'Disabled', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_top_bar" => array(
			'label' 	  => __( 'Top Bar', 'barta-core' ),
			'type'  	  => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'on'      => __( 'Enabled', 'barta-core' ),
				'off'     => __( 'Disabled', 'barta-core' ),
			),
			'default'  	  => 'default',
		),
		"{$prefix}_top_bar_style" => array(
			'label' 	=> __( 'Top Bar Layout', 'barta-core' ),
			'type'  	=> 'select',
			'options'	=> array(
				'default' => __( 'Default', 'barta-core' ),
				'1'       => __( 'Layout 1', 'barta-core' ),
				'2'       => __( 'Layout 2', 'barta-core' ),
				'3'       => __( 'Layout 3', 'barta-core' ),
				'4'       => __( 'Layout 4', 'barta-core' ),
			),
			'default'   => 'default',
		),
		"{$prefix}_header" => array(
			'label'   => __( 'Header Layout', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'1'       => __( 'Layout 1', 'barta-core' ),
				'2'       => __( 'Layout 2', 'barta-core' ),
				'3'       => __( 'Layout 3', 'barta-core' ),
				'4'       => __( 'Layout 4', 'barta-core' ),
				'5'       => __( 'Layout 5', 'barta-core' ),
				'6'       => __( 'Layout 6', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_top_padding" => array(
			'label'   => __( 'Content Padding Top', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'0px'     => __( '0px', 'barta-core' ),
				'10px'    => __( '10px', 'barta-core' ),
				'20px'    => __( '20px', 'barta-core' ),
				'30px'    => __( '30px', 'barta-core' ),
				'40px'    => __( '40px', 'barta-core' ),
				'50px'    => __( '50px', 'barta-core' ),
				'60px'    => __( '60px', 'barta-core' ),
				'70px'    => __( '70px', 'barta-core' ),
				'80px'    => __( '80px', 'barta-core' ),
				'90px'    => __( '90px', 'barta-core' ),
				'100px'   => __( '100px', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_bottom_padding" => array(
			'label'   => __( 'Content Padding Bottom', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'0px'     => __( '0px', 'barta-core' ),
				'10px'    => __( '10px', 'barta-core' ),
				'20px'    => __( '20px', 'barta-core' ),
				'30px'    => __( '30px', 'barta-core' ),
				'40px'    => __( '40px', 'barta-core' ),
				'50px'    => __( '50px', 'barta-core' ),
				'60px'    => __( '60px', 'barta-core' ),
				'70px'    => __( '70px', 'barta-core' ),
				'80px'    => __( '80px', 'barta-core' ),
				'90px'    => __( '90px', 'barta-core' ),
				'100px'   => __( '100px', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_banner_ticker" => array(
			'label'   => __( 'Banner Ticker', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'on'	  => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'off',
		),
		"{$prefix}_banner_info" => array(
			'label'   => __( 'Banner Info', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'on'	  => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_banner" => array(
			'label'   => __( 'Banner', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'on'	  => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_breadcrumb" => array(
			'label'   => __( 'Breadcrumb', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'on'      => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_banner_type" => array(
			'label'   => __( 'Banner Background Type', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'default' => __( 'Default', 'barta-core' ),
				'bgimg'   => __( 'Background Image', 'barta-core' ),
				'bgcolor' => __( 'Background Color', 'barta-core' ),
			),
			'default' => 'default',
		),
		"{$prefix}_banner_bgimg" => array(
			'label' => __( 'Banner Background Image', 'barta-core' ),
			'type'  => 'image',
			'desc'  => __( 'If not selected, default will be used', 'barta-core' ),
		),
		"{$prefix}_banner_bgcolor" => array(
			'label' => __( 'Banner Background Color', 'barta-core' ),
			'type'  => 'color_picker',
			'desc'  => __( 'If not selected, default will be used', 'barta-core' ),
		),		
		"{$prefix}_page_bgimg" => array(
			'label' => __( 'Page/Post Background Image', 'barta-core' ),
			'type'  => 'image',
			'desc'  => __( 'If not selected, default will be used', 'barta-core' ),
		),
		"{$prefix}_page_bgcolor" => array(
			'label' => __( 'Page/Post Background Color', 'barta-core' ),
			'type'  => 'color_picker',
			'desc'  => __( 'If not selected, default will be used', 'barta-core' ),
		),
	),
) );


$Postmeta->add_meta_box( "{$prefix}_ad_settings", __( 'Advertisement Settings', 'barta-core' ), array( 'page', 'post' ), '', '', 'high', array(
	'fields' => array(
		
		//akhon somoy
		"{$prefix}_header_top_ad" => array(
			'label'   => __( 'Header Top Ad.', 'barta-core' ),
			'type'    => 'select',
			'options' => array(				
				'on'      => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_header_below_ad" => array(
			'label'   => __( 'Header Below Ad.', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'on'      => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_footer_ad" => array(
			'label'   => __( 'Footer Top Ad.', 'barta-core' ),
			'type'    => 'select',
			'options' => array(				
				'on'      => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_content_top" => array(
			'label'   => __( 'Content Top Ad.', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'on'      => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),
		"{$prefix}_content_below" => array(
			'label'   => __( 'Content Below Ad.', 'barta-core' ),
			'type'    => 'select',
			'options' => array(
				'on'      => __( 'Enable', 'barta-core' ),
				'off'	  => __( 'Disable', 'barta-core' ),
			),
			'default'  => 'default',
		),

	
	) )
);

$Postmeta->add_meta_box( "{$prefix}_subtitle_info", __( 'Subtitle', 'barta-core' ), array( 'post' ), '', 'advanced','high', array(
	'fields' => array(
		
		//only post meta
		"{$prefix}_subtitle" => array(
			'label'   => __( 'Subtitle', 'barta-core' ),
			'type'    => 'text',
			'default'  => '',
		),
		"{$prefix}_youtube_link" => array(
			'label'   => __( 'Youtube Link', 'barta-core' ),
			'type'    => 'text',
			'default'  => '',
			'desc'  => __( 'Only work for the video post format', 'barta-core' ),
		),
	
	) )
);