<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

// Layout class
if ( BartaTheme::$layout == 'full-width' ) {
	$barta_layout_class = 'col-sm-9 col-xs-12';
} else {
	$barta_layout_class = 'col-sm-9 col-xs-12';
}

$barta_is_post_archive = is_home() || ( is_archive() && get_post_type() == 'post' ) ? true : false;

$barta_author_bio      = get_the_author_meta( 'description' );
$subtitle = get_post_meta( get_the_ID(), 'barta_subtitle', true );
$author = $post->post_author;

$news_author_fb = get_user_meta( $author, 'barta_facebook', true );
$news_author_tw = get_user_meta( $author, 'barta_twitter', true );
$news_author_ld = get_user_meta( $author, 'barta_linkedin', true );
$news_author_gp = get_user_meta( $author, 'barta_gplus', true );
$news_author_pr = get_user_meta( $author, 'barta_pinterest', true );
$barta_author_designation = get_user_meta( $author, 'barta_author_designation', true );
?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php if ( BartaTheme::$layout == 'left-sidebar' ) { get_sidebar(); } ?>
			<div class="<?php echo esc_attr( $barta_layout_class );?>">
				<main id="main" class="site-main">
					<!-- author bio -->
					<?php if ( BartaTheme::$options['post_author_bio'] == '1' ) { ?>
						<div class="media about-author">
							<div class="<?php if ( is_rtl() ) { ?>pull-right<?php } else { ?>pull-left<?php } ?>">
								<?php echo get_avatar( $author, 105 ); ?>
							</div>
							<div class="media-body">
								<div class="about-author-info">
									<div class="author-title"><?php the_author_posts_link();?></div>
									<div class="author-designation"><?php if ( !empty ( $barta_author_designation ) ) {	echo esc_html( $barta_author_designation ); } else { $user_info = get_userdata( $author ); echo esc_html ( implode( ', ', $user_info->roles ) );	} ?></div>
								</div>
								<?php if ( $barta_author_bio ) { ?>
								<div class="author-bio"><?php echo esc_html( $barta_author_bio );?></div>
								<?php } ?>
								<div class="about-author-social">
								<?php ?>
									<ul class="author-box-social">
										<?php if ( ! empty( $news_author_fb ) ){ ?><a href="<?php echo esc_attr( $news_author_fb ); ?>"><li><i class="fa fa-facebook" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_tw ) ){ ?><a href="<?php echo esc_attr( $news_author_tw ); ?>"><li><i class="fa fa-twitter" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_gp ) ){ ?><a href="<?php echo esc_attr( $news_author_gp ); ?>"><li><i class="fa fa-google-plus" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_ld ) ){ ?><a href="<?php echo esc_attr( $news_author_ld ); ?>"><li><i class="fa fa-linkedin" aria-hidden="true"></i></li></a><?php } ?>
										<?php if ( ! empty( $news_author_pr ) ){ ?><a href="<?php echo esc_attr( $news_author_pr ); ?>"><li><i class="fa fa-pinterest-p" aria-hidden="true"></i></li></a><?php } ?>
									</ul>
								<?php ?>
								</div>
							</div>
							<div class="clear"></div>
						</div>			
					<?php } ?>
					<?php
					if ( have_posts() ) { ?>
						<?php
						if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style4' ) {						
							echo '<div class="blog-layout-4 row rt-masonry-grid">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-4-masonry', get_post_format() );
							endwhile;
							echo '</div>';
						} elseif ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style3' ) {
							echo '<div class="blog-layout-3">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-3', get_post_format() );
							endwhile;
							echo '</div>';
						} elseif ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style2' ) {
							echo '<div class="row auto-clear">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-2', get_post_format() );
							endwhile;
							echo '</div>';
						} else if ( $barta_is_post_archive && BartaTheme::$options['blog_style'] == 'style1' ) {
							echo '<div class="auto-clear">';
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-1', get_post_format() );
							endwhile;
							echo '</div>';
						}
						else {
							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content-1', get_post_format() );
							endwhile;
						}

						?>
						<?php BartaTheme_Helper::pagination();?>
					<?php } else {?>
						<?php get_template_part( 'template-parts/content', 'none' );?>
					<?php } ?>
				</main>					
			</div>
			<?php
			if ( BartaTheme::$layout == 'right-sidebar' ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>