<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php
		// Preloader
		if ( BartaTheme::$options['preloader'] == '1' ){ 
			if ( !empty( BartaTheme::$options['preloader_image']['url'] ) ) {
				$preloader_img = BartaTheme::$options['preloader_image']['url'];
				echo '<div id="preloader" style="background-image:url(' . esc_url( $preloader_img ) . ');"></div>';
			} else { ?>
			<div id="preloader">
				<div class="preloader-wrap">
					<div class="preloader-content">
						<div class="circle"></div>
					</div>
				</div>
			</div>				
			<?php }			
		}
	?>
	<?php if ( is_singular() && ( BartaTheme::$options['scroll_indicator_enable'] == '1' ) && ( BartaTheme::$options['scroll_indicator_position'] == 'top' ) ){ ?>
	<div class="barta-progress-container">
		<div class="barta-progress-bar" id="bartaBar"></div>
	</div>
	<?php } ?>
	<div id="page" class="site">		
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'barta' ); ?></a>	
		
		<header id="masthead" class="site-header <?php if ( wp_is_mobile() ) {?>mean-remove<?php } ?>">
			<div id="header-<?php echo esc_attr( BartaTheme::$header_style ); ?>" class="header-area header-fixed ">
				<?php
					$is_ad_active1 = get_post_meta( get_the_ID(), 'barta_header_top_ad', true );
					if ( $is_ad_active1 == 'on' ) {
						do_action( 'barta_header_top' );
					}
				?>
				<?php
				if ( BartaTheme::$top_bar == 1 || BartaTheme::$top_bar == 'on' ){ ?>			
				<?php get_template_part( 'template-parts/header/header-top', BartaTheme::$top_bar_style ); ?>
				<?php }	get_template_part( 'template-parts/header/header', BartaTheme::$header_style ); ?>
			</div>
		</header>
		<?php get_template_part('template-parts/header/header', 'offscreen'); ?>		
		<div id="header-area-space"></div>
		<div id="content" class="site-content">
			<?php if ( BartaTheme::$options['show_search_bar'] ) { ?>
				<div class="show-ad-in-mobile mobile-header-search">
					<div class="container">
						<form role="search" method="get" class="search-form" action="<?php echo site_url(); ?>">
							<div class="row custom-search-input">
								<div class="input-group col-md-12">
								<input type="text" class="search-query form-control" placeholder="Search here ..." value="" name="s">
									<span class="input-group-btn">
										<button class="btn" type="submit">
											<i class="fa fa-search" aria-hidden="true"></i>
										</button>
									</span>
								</div>
							</div>
						</form>
					</div>
				</div>
			<?php } ?>
			<?php if ( ( BartaTheme::$header_style == 5 ) && ( BartaTheme::$options['show_in_mobile_5'] ) ) { ?>
				<div class="show-ad-in-mobile">
					<?php
						// which ad will work
						if ( BartaTheme::$options['header_ad_type_5'] == 'adrotate' ) {
							echo do_shortcode ( BartaTheme::$options['header_ad_adrotate_5'] );
						} else if ( BartaTheme::$options['header_ad_type_5'] == 'adcode' ) {
							print ( BartaTheme::$options['header_ad_code_5'] );
						}  else if ( BartaTheme::$options['header_ad_type_5'] == 'adimage' && !empty ( BartaTheme::$options['header_ad_image_5']['url'] ) ) { ?> 
						<a class="header-ad-color" target="<?php if ( BartaTheme::$options['header_ad_link_type_5'] == 'blank' ) { ?>_blank<?php } ?>"  href="<?php echo esc_url( BartaTheme::$options['header_adimage_link_5'] ); ?>"><img src="<?php echo esc_url( BartaTheme::$options['header_ad_image_5']['url'] ); ?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>
					<?php } ?>
				</div>
			<?php } ?>
			
			<?php if ( ( BartaTheme::$header_style == 2 ) && ( BartaTheme::$options['show_in_mobile_2'] ) ) { ?>
				<div class="show-ad-in-mobile">
					<?php
						if ( BartaTheme::$options['header_ad_type'] == 'adrotate' ) {
							echo do_shortcode ( BartaTheme::$options['header_ad_adrotate'] );
						} else if ( BartaTheme::$options['header_ad_type'] == 'adcode' ) {
							print ( BartaTheme::$options['header_ad_code'] );
						} else if ( BartaTheme::$options['header_ad_type'] == 'adimage' && !empty ( BartaTheme::$options['header_ad_image']['url'] ) ) { ?>
							<a class="header-ad-color"  target="<?php if ( BartaTheme::$options['header_ad_link_type_2'] == 'blank' ) { ?>_blank<?php } ?>"  href="<?php echo esc_url( BartaTheme::$options['header_adimage_link'] ); ?>"><img src="<?php echo esc_url( BartaTheme::$options['header_ad_image']['url'] ); ?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>
					<?php } ?>
				</div>
			<?php } ?>
			
			<?php if ( ( BartaTheme::$header_style == 4 ) && ( BartaTheme::$options['show_in_mobile_4'] ) ) { ?>
				<div class="show-ad-in-mobile">
					<?php
						// which ad will work
						if ( BartaTheme::$options['header_ad_type_4'] == 'adrotate' ) {
							echo do_shortcode ( BartaTheme::$options['header_ad_adrotate_4'] );
						} else if ( BartaTheme::$options['header_ad_type_4'] == 'adcode' ) {
							print ( BartaTheme::$options['header_ad_code_4'] );
						}  else if ( BartaTheme::$options['header_ad_type_4'] == 'adimage' && !empty ( BartaTheme::$options['header_ad_image_4']['url'] ) ) { ?> 
						<a class="header-ad-color" target="<?php if ( BartaTheme::$options['header_ad_link_type_4'] == 'blank' ) { ?>_blank<?php } ?>"  href="<?php echo esc_url( BartaTheme::$options['header_adimage_link_4'] ); ?>"><img src="<?php echo esc_url( BartaTheme::$options['header_ad_image_4']['url'] ); ?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>
					<?php } ?>
				</div>					
			<?php } ?>						
			<?php
				if ( BartaTheme::$has_banner_ticker == '1' || BartaTheme::$has_banner_ticker == 'on' ) { 
					get_template_part('template-parts/content', 'banner-ticker');
				}
			?>			
			<?php			
				if ( BartaTheme::$has_banner_info == '1' || BartaTheme::$has_banner_info == 'on' ) { 
					get_template_part('template-parts/content', 'banner-info');
				}
			?>
			<?php
				$is_ad_active2 = get_post_meta( get_the_ID(), 'barta_header_below_ad', true );
				if ( $is_ad_active2 == 'on' ) {
					do_action( 'barta_header_below' );
				}
			?>
			<?php
			if ( is_single() && BartaTheme::$options['post_style'] == 'style3' ) {
				
			} else {
				if ( BartaTheme::$has_banner == '1' || BartaTheme::$has_banner == 'on' ) { 
					get_template_part('template-parts/content', 'banner');
				}
			}
			?>