<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$ul_class = $post_classes = '';

$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['blog_date'] ) || BartaTheme::$options['blog_author_name'] || BartaTheme::$options['blog_comment_num'] || BartaTheme::$options['blog_cats'] ) ? true : false;
$barta_time_html       = sprintf( '%s <span>%s</span>,<span> %s</span>',get_the_time( 'M' ), get_the_time( 'd' ), get_the_time( 'Y' ) );
$barta_time_html       = apply_filters( 'barta_single_time', $barta_time_html );
$barta_time_html_2     = apply_filters( 'barta_single_time_no_thumb', get_the_time( get_option( 'date_format' ) ) );

$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;

$thumbnail = false;

$thumb_size = 'barta-size14';

if (  BartaTheme::$layout == 'right-sidebar' || BartaTheme::$layout == 'left-sidebar' ){
	$post_classes = array( 'col-lg-6 rt-grid-item' );
	$ul_class = 'side_bar';
} else {
	$post_classes = array( 'col-lg-4 rt-grid-item' );
	$ul_class = '';
}
	$id = get_the_ID();
	$content = get_the_content();
	$content = apply_filters( 'the_content', $content );
	$content = wp_trim_words( $content, BartaTheme::$options['post_content_limit'] );
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?> >
	<div class="blog-layout blog-layout-2 blog-layout-4-masonry" data-layout="<?php echo esc_attr( BartaTheme::$layout ); ?>" >
		<div class="blog-img-holder">
			<a href="<?php the_permalink(); ?>" class="img-opacity-hover">
			<?php if ( has_post_thumbnail() ) { ?>
				<?php the_post_thumbnail( 'barta-size14', ['class' => 'img-responsive'] );?>
			<?php } else {
				if ( BartaTheme::$options['display_no_preview_image'] == '1' ) {
					if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
						$thumbnail = wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
					}
					elseif ( empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
						$thumbnail = '<img class="attachment-barta-size6 size-barta-size6 wp-post-image" src="'.BARTA_IMG_URL.'noimage-400x323.jpg" alt="'. the_title_attribute(array('echo'=> false)) .'">';
					}
					echo wp_kses_post( $thumbnail );
				}
			} ?></a>
			<?php if ( BartaTheme::$options['blog_cats'] ) { ?><?php echo barta_category_prepare(); ?><?php } ?>
		</div>
		<div class="blog-bottom-content-holder">
			<ul>
				<?php if ( BartaTheme::$options['blog_author_name'] ) { ?>
					<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link();?></li>
				<?php } ?>
				<?php if ( BartaTheme::$options['blog_date'] ) { ?>
					<li><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo get_the_time( get_option( 'date_format' ) ); ?></li>
				<?php } ?>
				<?php if ( BartaTheme::$options['blog_comment_num'] ) { ?>
					<li><i class="fa fa-comment-o" aria-hidden="true"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo esc_html( $barta_comments_html );?></a></li>
				<?php } ?>
			</ul>
			<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>		
			<div class="blog-text"><?php echo wp_kses_post( $content ); ?></div>
		</div>
	</div>
</div>
