<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$ul_class = $post_classes = '';

$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['blog_date'] ) || BartaTheme::$options['blog_author_name'] || BartaTheme::$options['blog_comment_num'] || BartaTheme::$options['blog_cats'] ) ? true : false;
$barta_time_html       = sprintf( '%s <span>%s</span>,<span> %s</span>',get_the_time( 'M' ), get_the_time( 'd' ), get_the_time( 'Y' ) );
$barta_time_html       = apply_filters( 'barta_single_time', $barta_time_html );
$barta_time_html_2     = apply_filters( 'barta_single_time_no_thumb', get_the_time( get_option( 'date_format' ) ) );

$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;

$thumbnail = false;

$thumb_size = 'barta-size14';

if (  BartaTheme::$layout == 'right-sidebar' || BartaTheme::$layout == 'right-sidebar' ){
	$post_classes = array( 'col-lg-6 col-md-6 col-sm-6 col-xs-12 rt-grid-item blog-layout-5-masonry' );
	$ul_class = 'side_bar';
} else {
	$post_classes = array( 'col-lg-4 col-md-4 col-sm-4 col-xs-12 rt-grid-item blog-layout-5-masonry' );
	$ul_class = '';
}

?>
<div id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?> data-layout="<?php echo esc_attr( BartaTheme::$layout ); ?>">
	<div class="blog-box">								
		<div class="blog-img-holder">	
			<a href="<?php the_permalink(); ?>">
			<?php if ( has_post_thumbnail() ) { ?>
				<?php the_post_thumbnail( 'barta-size2', array( 'class' => 'img-responsive' ) );?>
			<?php } else {
				if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
					$thumbnail = wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
				}
				echo wp_kses_post( $thumbnail );
			} ?></a>
		</div>
		<div class="blog-bottom-content-holder">
			<ul class="<?php echo esc_attr( $ul_class ); ?>">	
				<?php if ( BartaTheme::$options['blog_date'] ) { ?>			
				<li class="blog-date"><i class="fa fa-calendar" aria-hidden="true"></i><?php echo get_the_date();?></li>
				<?php } if ( BartaTheme::$options['blog_author_name'] ) { ?>
				<li><i class="fa fa-user-circle" aria-hidden="true"></i><?php the_author_posts_link(); ?></li>
				<?php } if ( BartaTheme::$options['blog_comment_num'] ) { ?>
				<li><i class="fa fa-comments-o" aria-hidden="true"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo esc_html( $barta_comments_html );?></a></li>
				<?php } ?>
			</ul>
			<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<?php
				$id = get_the_ID();
				$content = get_the_content();
				$content = apply_filters( 'the_content', $content );
				$content = wp_trim_words( $content, 30 );
			?>
			<p><?php echo wp_kses_post( $content ); ?></p>
			<a class="blog-button" href="<?php the_permalink(); ?>"><span><?php esc_html_e( 'Read More', 'barta' ); ?></span><?php if ( is_rtl() ) { ?><i class="fa fa-angle-left" aria-hidden="true"></i><?php } else { ?><i class="fa fa-angle-right" aria-hidden="true"></i><?php } ?></a>
		</div>
	</div>
</div>