<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
 
if ( function_exists( 'is_woocommerce' ) && is_woocommerce() ) {
	$barta_title = woocommerce_page_title( false );
} else if ( is_404() ) {
	$barta_title = BartaTheme::$options['error_title'];
} else if ( is_search() ) {
	$barta_title = esc_html__( 'Search Results for : ', 'barta' ) . get_search_query();
} else if ( is_home() ) {
	if ( get_option( 'page_for_posts' ) ) {
		$barta_title = get_the_title( get_option( 'page_for_posts' ) );
	}
	else {
		$barta_title = apply_filters( 'theme_blog_title', esc_html__( 'All Posts', 'barta' ) );
	}
} else if ( is_archive() ) {
	$barta_title = get_the_archive_title();
} else if ( is_page() ) {
	$barta_title = get_the_title();
} else if ( is_single() ) {
	$barta_title = get_the_title();
}

if ( BartaTheme::$bgtype == 'bgcolor' ) {
	$barta_bg = BartaTheme::$bgcolor;
} else {
	$barta_bg = 'url(' . BartaTheme::$bgimg . ') no-repeat scroll center center / cover';
}

if ( !empty( BartaTheme::$options['post_banner_title'] ) ){
	$post_banner_title = BartaTheme::$options['post_banner_title'];
} else {
	$post_banner_title = esc_html__( 'Our News' , 'barta' );
}

?>
<?php if ( BartaTheme::$has_banner == '1' || BartaTheme::$has_banner == 'on' ): ?>
	<div class="entry-banner" style="background:<?php echo esc_html( $barta_bg ); ?>">
		<div class="container">
			<div class="entry-banner-content">
			<?php
			
			if ( is_single() && 'video' == get_post_format( get_the_ID() ) ) { ?>
				<?php
						$categories = get_the_category();
						$count = count( $categories );
						$i = 0;
						if ( ! empty( $categories ) ) {
							foreach( $categories as $category ) {
							 $i++;
							?>
							<h1 class="entry-title"><a href="<?php echo get_category_link( $category->term_id ); ?>"><?php echo esc_html( $category->name ); ?></a></h1>
							<?php if ( $count != $i ) {	echo ', '; }
							}
						} else {
							echo wp_kses_post ( $post_banner_title );
						}
					?>
				<?php } else if ( is_single() ) { ?>
				<h1 class="entry-title"><?php echo wp_kses_post( $barta_title );?></h1>
				<?php } else if ( is_page() ) { ?>
					<h1 class="entry-title"><?php echo wp_kses_post( $barta_title );?></h1>
				<?php } else { ?>
					<h1 class="entry-title"><?php echo wp_kses_post( $barta_title );?></h1>
				<?php } ?>
				<?php if ( BartaTheme::$has_breadcrumb == '1' || BartaTheme::$has_breadcrumb == 'on' ) { ?>
					<?php get_template_part( 'template-parts/content', 'breadcrumb' );?>
				<?php } ?>
			</div>
		</div>
	</div>
<?php endif; ?>