<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['blog_date'] ) || BartaTheme::$options['blog_author_name'] || BartaTheme::$options['blog_comment_num'] || BartaTheme::$options['blog_cats'] ) ? true : false;
$barta_time_html       = sprintf( '%s<span>%s</span><span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );
$barta_time_html       = apply_filters( 'barta_single_time', $barta_time_html );
$barta_time_html_2     = apply_filters( 'barta_single_time_no_thumb', get_the_time( get_option( 'date_format' ) ) );

$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'blog-layout-1' ); ?>>
	<div class="entry-header">
		<div class="entry-content">
			<h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
			<?php if ( $barta_has_entry_meta ) { ?>
				<div class="entry-meta">
					<ul>
						<?php if ( BartaTheme::$options['blog_author_name'] ) { ?>
							<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link();?></li>
						<?php } ?>
						<?php if ( BartaTheme::$options['blog_date'] ) { ?>
							<li><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo get_the_time( get_option( 'date_format' ) ); ?></li>
						<?php } ?>
						<?php if ( BartaTheme::$options['blog_comment_num'] ) { ?>
							<li><i class="fa fa-comment-o" aria-hidden="true"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo esc_html( $barta_comments_html );?></a></li>
						<?php } ?>
					</ul>
				</div>
			<?php } ?>
			<?php the_excerpt();?>
		</div>
	</div>
</div>