<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['post_date'] ) || BartaTheme::$options['post_author_name'] || BartaTheme::$options['post_comment_num'] || BartaTheme::$options['post_cats'] ) ? true : false;

$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;
$barta_author_bio      = get_the_author_meta( 'description' );

$subtitle = get_post_meta( get_the_ID(), 'barta_subtitle', true );
$youtube_link = get_post_meta( get_the_ID(), 'barta_youtube_link', true );
$author = $post->post_author;

$news_author_fb = get_user_meta( $author, 'barta_facebook', true );
$news_author_tw = get_user_meta( $author, 'barta_twitter', true );
$news_author_ld = get_user_meta( $author, 'barta_linkedin', true );
$news_author_gp = get_user_meta( $author, 'barta_gplus', true );
$news_author_pr = get_user_meta( $author, 'barta_pinterest', true );
$barta_author_designation = get_user_meta( $author, 'barta_author_designation', true );
$caption_place_class = "";
/*Featured Image caption*/
if ( !empty( BartaTheme::$options['show_caption'] ) && BartaTheme::$options['show_caption'] == true ) {
	/*alignment*/
	if ( !empty( BartaTheme::$options['show_caption_align'] ) && BartaTheme::$options['show_caption_align'] == 'cap_right' ) {
		$cap_align_class = 'text-right';
	} else if ( !empty( BartaTheme::$options['show_caption_align'] ) && BartaTheme::$options['show_caption_align'] == 'cap_left' ) {
		$cap_align_class = 'text-left';
	} else if ( !empty( BartaTheme::$options['show_caption_align'] ) && BartaTheme::$options['show_caption_align'] == 'cap_center' ) {
		$cap_align_class = 'text-center';
	} else {
		$cap_align_class = 'text-justify';
	}
	if ( !empty( BartaTheme::$options['show_caption_place'] )) {
		$caption_place_class = BartaTheme::$options['show_caption_place'];
	}
}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div id="contentHolder">
	<div class="entry-header">
		<?php if ( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $id ) && !empty( $youtube_link ) )  ) {		
			preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $youtube_link, $match);
			$youtube_id = $match[1];
		}
		if ( !empty($youtube_id) ) { ?>
			<?php if ( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $id ) )  ) { ?>
				<?php if(strlen( get_the_title() ) >0 ): ?><h2 class="entry-title"><?php the_title(); ?></h2><?php endif; ?>
				<div class="entry-content entry-thumbnail-area">
					<div class="embed-responsive embed-responsive-16by9">
						<iframe class="embed-responsive-item" src="https://www.youtube.com/embed/<?php echo esc_attr( $youtube_id ); ?>" allowfullscreen></iframe>
					</div>
				</div>
			<?php } ?>
		<?php } else { ?>
			<?php if ( BartaTheme::$options['post_featured_image'] == true ) { ?>
				<?php if ( has_post_thumbnail() ) { ?>
					<div class="entry-thumbnail-area <?php echo esc_attr( $caption_place_class ); ?>">
						<img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" alt="<?php echo get_the_title(); ?>" />
						<?php if ( BartaTheme::$options['show_caption'] == true ) { ?>
							<?php if ( get_post(get_post_thumbnail_id())->post_excerpt ) { ?>
								<div class="featured-image-caption <?php echo esc_attr( $cap_align_class ); ?>"><?php echo wp_kses_post(get_post(get_post_thumbnail_id())->post_excerpt); ?></div>
							<?php } ?>
						<?php } ?>
					</div>
				<?php } ?>
			<?php } ?>
		<?php } ?>
		<?php
			$is_ad_active3 = get_post_meta( get_the_ID(), 'barta_content_top', true );
			if ( $is_ad_active3 == 'on' ) {
				do_action( 'barta_before_content' );
			}
		?>		
		<?php if ( BartaTheme::$has_banner == '0' || BartaTheme::$has_banner == 'off' ) { ?> 			
			<?php if ( BartaTheme::$has_breadcrumb == '1' || BartaTheme::$has_breadcrumb == 'on' ) { ?>
				<?php get_template_part( 'template-parts/content', 'breadcrumb' );?>
			<?php } ?>
			<h1 class="entry-title"><?php echo get_the_title(); ?></h1>			
		<?php } ?>
		<?php if ( !empty( $subtitle ) && BartaTheme::$options['post_subtitle'] && ($subtitle != 'default') ) { ?>		
				<h3 class="entry-sub-title"><?php echo wp_kses_post( $subtitle ); ?></h3>
			<?php } ?>
		<?php if ( $barta_has_entry_meta ) { ?>
		<div class="entry-meta">
			<div class="entry-category">
				<?php if ( BartaTheme::$options['post_cats'] ) { ?>
				<div class="entry-cat-tag">
					<div class="ui-cat">
						<?php
							$categories = get_the_category();
							$separator = ' ';
							$output = '';
							if ( ! empty( $categories ) ) {
								foreach( $categories as $category ) {
								$get_color  = get_term_meta( $category->term_id , 'rt_category_color', true );
						?>
							<div class="ui-cat-tag" style="background:#<?php echo esc_attr( $get_color ); ?>">
							<span class="amount"><a href="<?php echo get_category_link( $category->term_id ); ?>"><?php echo esc_html( $category->name ); ?></a></span>
							<span class="r1"></span>
							<span class="r2"></span>
							<span class="r3"></span>
							</div>
						<?php }	} ?>
					</div>
				</div>
				<?php } ?>
			</div>
			<div class="entry-date">
				<ul>
					<?php if ( ( BartaTheme::$options['post_date'] ) && ( BartaTheme::$options['show_above_date'] ) ) { ?>
					<li><span class="fa fa-clock-o" aria-hidden="true"></span> <span class="published updated"><?php echo get_the_date(); ?></span></li>
					<?php } ?>
				</ul>									
			</div>
			<?php } ?>
			
			<div class="entry-post-meta row">
				<div class="col-sm-8 col-xs-12 <?php if ( is_rtl() ) { ?> pull-right text-left <?php } else { ?> pull-left text-left <?php } ?> post-author">
					<?php
					if ( BartaTheme::$options['post_author_name'] == '1' ) {
						echo get_avatar( get_the_author_meta( 'ID', $author ), 35, null, get_the_author_meta('display_name', $author) );
						echo esc_html__( 'By ', 'barta' );
						
						printf('<a href="%1$s"><span class="vcard author author_name"><span class="fn">%2$s</span></span></a>',
						esc_url( get_author_posts_url( get_the_author_meta('ID', $author) ) ),
						get_the_author_meta('display_name', $author));
					}
					?> 
					<?php if ( BartaTheme::$options['post_author_social'] == '1' ) { ?> -
					<?php if ( !empty( $news_author_tw ) ) { ?>
					<a target="_blank" class="author-social" href="http://twitter.com/<?php the_author_meta( 'barta_twitter' ); ?>" title="Follow <?php the_author_meta( 'display_name' ); ?> on Twitter"><i class="fa fa-twitter" aria-hidden="true"></i></a>
					<?php } if ( !empty( $news_author_fb ) ) { ?>
					<a target="_blank" class="author-social" href="<?php the_author_meta( 'barta_facebook' ); ?>" title="<?php the_author_meta( 'display_name' ); ?> facebook"><i class="fa fa-facebook-official" aria-hidden="true"></i></a>
					<?php } if ( !empty( get_the_author_meta( 'user_url' ) ) ) { ?>
					<a target="_blank" class="author-social" href="<?php echo get_the_author_meta( 'user_url' ); ?>" title="<?php the_author_meta( 'user_url' ); ?> website"><i class="fa fa-globe" aria-hidden="true"></i></a>
					<?php } if ( !empty( get_the_author_meta( 'user_email' ) ) ) { ?>
					<a target="_blank" class="author-social" href="mailto:<?php the_author_meta( 'user_email' ); ?>" title="<?php the_author_meta( 'display_name' ); ?>"><i class="fa fa-envelope" aria-hidden="true"></i></a> 
					<?php } ?>
					<?php } ?>
					<?php if ( BartaTheme::$options['post_date'] ) { ?>
						<span><?php barta_get_time(); ?></span>
					<?php } ?>
				</div>
				<div class="col-sm-4 col-xs-12 <?php if ( is_rtl() ) { ?> pull-right text-left <?php } else { ?> pull-left text-right <?php } ?>">
				
					<?php if ( BartaTheme::$options['post_comment_num'] ) { ?>
					<span><i class="fa fa-comments-o" aria-hidden="true"></i> <?php comments_number( '0', '1', '%' ); ?></span>
					<?php } ?>
					<?php if ( BartaTheme::$options['post_view'] && function_exists( 'barta_views' ) ) { ?>
					<span class="meta-views meta-item "><?php echo barta_views(); ?></span>
					<?php } ?>
					<?php if ( BartaTheme::$options['post_length'] && function_exists( 'barta_reading_time' ) ) { ?>
					<span class="meta-reading-time meta-item"> <?php echo barta_reading_time(); ?></span>
					<?php } ?>
					
				</div>
			</div>
			<?php if ( BartaTheme::$options['post_share_display_top'] == '1' ) { ?>
			<?php if( function_exists( 'barta_post_share' )){ barta_post_share(); } ?>
			<?php } ?>
			<div class="clear"></div>
		</div>
	</div>
	<?php 
	if ( !empty( get_the_content() ) ) { ?>
	<div class="entry-content"><?php the_content();?>
		<?php wp_link_pages();?>
	</div>
	<?php } ?>
	</div>
	<?php if ( BartaTheme::$options['post_tags'] && has_tag() ) { ?>
	<div class="entry-footer">
		<div class="entry-footer-meta">			
			<div class="item-tags">
				<span><?php esc_html_e( 'Tags:', 'barta' );?></span><?php echo get_the_term_list( $post->ID, 'post_tag', '<ul class="tag_styles"><li>', '</li><li>', '</li></ul>' );?>
			</div>
		</div>
	</div>
	<?php } ?>	
	<?php
		$is_ad_active4 = get_post_meta( get_the_ID(), 'barta_content_below', true );
		if ( $is_ad_active4 == 'on' ) {
			do_action( 'barta_after_content' );
		}
	?>	
	<!--bottom share -->
	<?php if ( ( BartaTheme::$options['post_share_display_footer'] == '1') && function_exists( 'barta_post_share' ) ) { ?>
		<div class="post-share-area post-footer-share">
			<p><?php esc_html_e( 'You can share this post!', 'barta' ); ?></p>
			<?php if ( function_exists( 'barta_post_share' )){ barta_post_share(); } ?>
		</div>	
	<?php } else { ?>
		<div class="post-bottom-spacer" ></div>
	<?php } ?>
	<!-- next/prev post -->
	<?php if ( BartaTheme::$options['post_links'] ) { barta_post_links_next_prev(); } ?>
	
	<!-- author bio -->
	<?php if ( BartaTheme::$options['post_author_bio'] == '1' ) { ?>
		<div class="media about-author">
			<div class="<?php if ( is_rtl() ) { ?>pull-right<?php } else { ?>pull-left<?php } ?>">
				<?php echo get_avatar( $author, 105 ); ?>
			</div>
			<div class="media-body">
				<div class="about-author-info">
					<div class="author-title"><?php the_author_posts_link();?></div>
					<div class="author-designation"><?php if ( !empty ( $barta_author_designation ) ) {	echo esc_html( $barta_author_designation ); } else {	$user_info = get_userdata( $author ); echo esc_html ( implode( ', ', $user_info->roles ) );	} ?></div>
				</div>
				<?php if ( $barta_author_bio ) { ?>
				<div class="author-bio"><?php echo esc_html( $barta_author_bio );?></div>
				<?php } ?>
				<div class="about-author-social">
				<?php ?>
				<ul class="author-box-social">
					<?php if ( ! empty( $news_author_fb ) ){ ?><a href="<?php echo esc_attr( $news_author_fb ); ?>"><li><i class="fa fa-facebook" aria-hidden="true"></i></li></a><?php } ?>
					<?php if ( ! empty( $news_author_tw ) ){ ?><a href="<?php echo esc_attr( $news_author_tw ); ?>"><li><i class="fa fa-twitter" aria-hidden="true"></i></li></a><?php } ?>
					<?php if ( ! empty( $news_author_gp ) ){ ?><a href="<?php echo esc_attr( $news_author_gp ); ?>"><li><i class="fa fa-google-plus" aria-hidden="true"></i></li></a><?php } ?>
					<?php if ( ! empty( $news_author_ld ) ){ ?><a href="<?php echo esc_attr( $news_author_ld ); ?>"><li><i class="fa fa-linkedin" aria-hidden="true"></i></li></a><?php } ?>
					<?php if ( ! empty( $news_author_pr ) ){ ?><a href="<?php echo esc_attr( $news_author_pr ); ?>"><li><i class="fa fa-pinterest-p" aria-hidden="true"></i></li></a><?php } ?>
				</ul>
				<?php ?>
				</div>
			</div>
			<div class="clear"></div>
		</div>			
	<?php } ?>
	
	<?php if( BartaTheme::$options['show_related_post'] == '1' && is_single() ) { ?>
		<div class="related-post">
			<?php barta_related_post(); ?>
		</div>
	<?php } ?>
	
</div>