<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = BartaTheme_Helper::nav_menu_args();

// Logo
$barta_dark_logo = empty( BartaTheme::$options['logo']['id'] ) ? '<img width="190" height="50" alt="'.get_bloginfo( 'name' ).'" src="'.BARTA_IMG_URL.'logo-dark.png'.'">' : wp_get_attachment_image(BartaTheme::$options['logo']['id'],'full');
$barta_light_logo = empty( BartaTheme::$options['logo_light']['id'] ) ? '<img width="190" height="50" alt="'.get_bloginfo( 'name' ).'" src="'.BARTA_IMG_URL.'logo-light.png'.'">' : wp_get_attachment_image(BartaTheme::$options['logo_light']['id'],'full');

$barta_logo_col_num = (int) BartaTheme::$options['logo_width'];

// Menu and Icon wrapper classes
$barta_icon_count = 0;
if ( BartaTheme::$options['search_icon'] ) {
	$barta_icon_count++;
}
if ( BartaTheme::$options['cart_icon'] && class_exists( 'WooCommerce' ) ) {
	$barta_icon_count++;
}

switch ( $barta_icon_count ) {
	case 1:
	$barta_icon_col_num = 1;	
	break;
	case 2:
	$barta_icon_col_num = 2;
	break;
	case 3:
	$barta_icon_col_num = 2;
	break;	
	default:
	$barta_icon_col_num = 1;
	break;
} 

$barta_logo_class = "col-sm-{$barta_logo_col_num} col-xs-12";
$barta_menu_class = 'col-sm-'. ( 12 - $barta_logo_col_num - $barta_icon_col_num ) . ' col-xs-12';
$barta_icon_class = "col-sm-". $barta_icon_col_num ." col-xs-12";

?>
<div class="container masthead-container" id="sticker">
	<div class="row">
		<div class="<?php echo esc_attr( $barta_logo_class );?>">
			<div class="site-branding">
				<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $barta_dark_logo;?></a>
				<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $barta_light_logo;?></a>
			</div>
		</div>
		<div class="<?php echo esc_attr( $barta_menu_class );?>">
			<div id="site-navigation" class="main-navigation">
				<?php wp_nav_menu( $nav_menu_args );?>
			</div>
		</div>
		<div class="<?php echo esc_attr( $barta_icon_class );?>">
			<?php if ( $barta_icon_count ): ?>
				<?php get_template_part( 'template-parts/header/icon', 'area' );?>
			<?php endif; ?>
		</div>
	</div>
</div>

<div class="rt-sticky-menu-wrapper rt-sticky-menu">
	<div class="container">
		<div class="row">
			<div class="col-sm-2 col-xs-12">
				<div class="site-branding">
					<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo $barta_light_logo;?></a>
				</div>
			</div>
			<div class="col-sm-10 col-xs-12">
				<div class="main-navigation">
					<?php wp_nav_menu( $nav_menu_args );?>
				</div>
			</div>
		</div>
	</div>
</div>