<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$barta_socials = BartaTheme_Helper::socials();
$barta_light_logo = empty( BartaTheme::$options['logo_light']['url'] ) ? BARTA_IMG_URL . 'logo-light.png' : BartaTheme::$options['logo_light']['url'];
?>
<div class="additional-menu-area">
	<div class="sidenav">
		<a href="#" class="closebtn">x</a>		
		<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><img src="<?php echo esc_url( $barta_light_logo );?>" alt="<?php esc_attr( bloginfo( 'name' ) ) ;?>"></a>
		<?php wp_nav_menu( array( 'theme_location' => 'topright','container' => '' ) );?>
		
		<div class="sidenav-address">
			<h3><?php esc_html_e( 'Info', 'barta' );?></h3>
			<?php if ( BartaTheme::$options['address'] ): ?>
			<span><?php echo wp_kses_post( BartaTheme::$options['address'] );?></span>
			<?php endif; ?>
			<?php if ( BartaTheme::$options['phone'] ): ?>
			<span><a href="tel:<?php echo esc_attr( BartaTheme::$options['phone'] );?>"><?php echo esc_html( BartaTheme::$options['phone'] );?></a></span>
			<?php endif; ?>
			<?php if ( BartaTheme::$options['email'] ): ?>
			<span><a href="mailto:<?php echo esc_attr( BartaTheme::$options['email'] );?>"><?php echo esc_html( BartaTheme::$options['email'] );?></a></span>
			<?php endif; ?>
			<?php if ( $barta_socials ): ?>
				<div class="sidenav-social">
					<?php foreach ( $barta_socials as $barta_social ): ?>
						<span><a target="_blank" href="<?php echo esc_url( $barta_social['url'] );?>"><i class="fa <?php echo esc_attr( $barta_social['icon'] );?>"></i></a></span>
					<?php endforeach; ?>					
				</div>						
			<?php endif; ?>
		</div>
	</div>
	<a class="side-menu-open side-menu-trigger">
		<span></span>
		<span></span>
		<span></span>
	</a>
</div>