<?php

class PxlCounterBox_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter_box';
    protected $title = 'Case Counter Box';
    protected $icon = 'eicon-counter-circle';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Text","type":"textarea","label_block":true},{"name":"t_width","label":"Title Width","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--holder .pxl-counter--title":"width: {{SIZE}}{{UNIT}};"}},{"name":"starting_number","label":"Starting Number","type":"number","default":1},{"name":"ending_number","label":"Ending Number","type":"number","default":100},{"name":"prefix","label":"Number Prefix","type":"text","default":""},{"name":"suffix","label":"Number Suffix","type":"text","default":""},{"name":"under_suffix","label":"Plus Under","type":"text","default":""},{"name":"thousand_separator_char","label":"Number Separator","type":"select","options":{"":"Default",".":"Dot",",":"Comma"," ":"Space"},"default":""},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-counter":"text-align: {{VALUE}};"}}]},{"name":"section_style_general","label":"General","tab":"style","controls":[{"name":"effect","label":"Effect","type":"select","options":{"effect-default":"Default","effect-slide":"Slide"},"default":"effect-default"},{"name":"wg_max_width","label":"Widget Max Width","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box":"width: {{SIZE}}{{UNIT}};"}},{"name":"wg_max_height","label":"Widget Max Width","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-counter-box":"height: {{SIZE}}{{UNIT}};"}},{"name":"btn_gradient","label":"Background Type","type":"background","control_type":"group","types":["gradient"],"selector":"{{WRAPPER}} .pxl-counter-box"}]},{"name":"section_style_title","label":"Title","tab":"style","controls":[{"name":"title_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--title":"color: {{VALUE}};"}},{"name":"title_bg","label":"Bg Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--title":"background: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-counter--title"}]},{"name":"section_number","label":"Number","tab":"style","controls":[{"name":"number_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--number":"color: {{VALUE}};"}},{"name":"prefix_suffix_color","label":"Prefix Suffix Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--number span:not(.pxl-counter--value)":"color: {{VALUE}};"}},{"name":"number_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter-box .pxl-counter--number"},{"name":"duration","label":"Animation Duration","type":"number","default":2000,"min":100,"step":100},{"name":"number_space_top","label":"Top Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--number":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"number_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-counter-box .pxl-counter--number":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"shape_number","label":"Shape","type":"select","options":{"shape-show":"Show","shape-hide":"Hide"},"default":"shape-show","condition":{"style":"style-1"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","wow fadeInPopup":"fadeInPopup","wow animate-on-scroll":"fadeInUp on Scroll"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'elementor-waypoints','jquery-numerator','pxl-counter','pxl-counter-slide','aimo-counter' );
}