<?php
/**
 * @package Case-Themes
 */

 if ( post_password_required() ) {
    return;
    } ?>

    <div id="comments" class="comments-area">

        <?php
        if ( have_comments() ) : ?>
            <div class="comment-list-wrap">

                <?php the_comments_navigation(); ?>

                <ul class="comment-list">
                    <?php
                        wp_list_comments( array(
                            'style'      => 'ul',
                            'short_ping' => true,
                            'callback'   => 'aimo_comment_list',
                            'max_depth'  => 3
                        ) );
                    ?>
                </ul>

                <?php the_comments_navigation(); ?>
            </div>
            <?php if ( ! comments_open() ) : ?>
                <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'aimo' ); ?></p>
            <?php
            endif;

        endif;

        $args = array(
            'id_form'           => 'commentform',
            'id_submit'         => 'submit',
            'class_submit'      => 'btn btn-text-parallax btn-icon-box',
            'title_reply'       => esc_attr__( 'Leave A Comment', 'aimo'),
            'title_reply_to'    => esc_attr__( 'Leave A Comment To ', 'aimo') . '%s',
            'cancel_reply_link' => esc_attr__( 'Cancel Comment', 'aimo'),
            'submit_button'     => '<button name="%1$s" type="submit" id="%2$s" class="btn btn-icon-box4"><span class="pxl--btn-text">%4$s</span><span class="pxl--btn-icon"><i aria-hidden="true" class="flaticon flaticon-next"></i></span></button>',
            'comment_notes_before' => '',
            'fields' => apply_filters( 'comment_form_default_fields', array(

            'author' =>
            '<div class="row"><div class="comment-form-author co-12">'.
            '<label for="author" class="form-label">'.esc_html__('FIRST NAME', 'aimo').'</label>'.
            '<input id="author" name="author" type="text" value="" size="30" placeholder="'.esc_attr__('e.g. Oliver Spiteri', 'aimo').'" class="form-control" required/></div>',

            'lastname' =>
            '<div class="comment-form-lastname co-12">'.
            '<label for="lastname" class="form-label">'.esc_html__('LAST NAME', 'aimo').'</label>'.
            '<input id="lastname" name="lastname" type="text" value="" size="30" placeholder="'.esc_attr__('e.g. Oliver Spiteri', 'aimo').'" class="form-control" required/></div>',

            'email' =>
            '<div class="comment-form-email col-12">'.
            '<label for="email" class="form-label">'.esc_html__('EMAIL', 'aimo').'</label>'.
            '<input id="email" name="email" type="email" value="" size="30" placeholder="'.esc_attr__('example@email.com', 'aimo').'" class="form-control" required/></div>',
        )),
            'comment_field' =>  '<div class="comment-form-comment col-12"><label for="comment" class="form-label">'.esc_html__('COMMENT', 'aimo').'</label><textarea id="comment" name="comment" cols="45" rows="8" placeholder="'.esc_attr__('Write your comment here...', 'aimo').'" aria-required="true" class="form-control"></textarea></div>',
        );        
    comment_form($args); ?>
</div>