<?php
$active = intval($settings['active']);
$accordion = $widget->get_settings('accordion');
$wg_id = pxl_get_element_id($settings);
if(!empty($accordion)) : ?>
    <div class="pxl-accordion pxl-accordion2 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($accordion as $key => $value):
            $is_active = ($key + 1) == $active;
            $pxl_id = isset($value['_id']) ? $value['_id'] : '';
            $title = isset($value['title']) ? $value['title'] : '';
            $desc = isset($value['desc']) ? $value['desc'] : '';
            $number = isset($value['number']) ? $value['number'] : '';
            $icon_image = isset($value['icon_image']) ? $value['icon_image'] : '';
             ?>
            <div class="pxl--item <?php echo esc_attr($is_active ? 'active' : ''); ?>">
                <<?php pxl_print_html($settings['title_tag']); ?> class="pxl-accordion--title" data-target="<?php echo esc_attr('#'.$wg_id.'-'.$pxl_id); ?>">
                    <div class="pxl-title--number pxl-empty"><?php echo esc_html($number); ?></div>
                        <span class="pxl-title--text"><?php echo wp_kses_post($title); ?></span>
                    <?php if($settings['style'] == 'style-default') : ?><span class="pxl-icon--action"><span class="pxl-icon--plus"><span></span></span></span><?php endif; ?>
                </<?php pxl_print_html($settings['title_tag']); ?>>
                <div id="<?php echo esc_attr($wg_id.'-'.$pxl_id); ?>" class="pxl-accordion--content" <?php if($is_active){ ?>style="display: block;"<?php } ?>>
                    <?php if(!empty( $icon_image['id'])) { 
                        $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '152x120'; 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  =>  $icon_image['id'],
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail']; ?>
                        <div class="pxl-item--image">
                                <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php } ?>
                    <?php echo wp_kses_post(nl2br($desc)); ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>