<?php 
$title_item1 = $settings['title_item1'];
$content1 = $settings['content1'];
$button = $settings['button'];
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';

$img = pxl_get_image_by_size( array(
    'attach_id'  => $settings['image']['id'],
    'thumb_size' => $image_size,
    'class' => 'no-lazyload'
) );
$thumbnail1 = $img['thumbnail'];
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
?>

<div class="pxl-banner-edit pxl-banner-edit1<?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item-inner">
        <div class="pxl-contact">
            <div class="wrap-content">
                <h4 class="pxl-item-title"><?php echo pxl_print_html($title_item1); ?></h4>
                <div class="pxl-item-content"><?php echo pxl_print_html($content1); ?></div>
                <a class="pxl-link" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>>
                    <div class="">
                        <?php 
                            $default_settings = [
                                'style' => '',
                                'text_placeholder' => '',
                                'text_button' => '',
                                'post_type' => '',
                                'quick_user' => '',
                            ];
                            $settings = array_merge($default_settings, $settings);
                            extract($settings);
                            ?>

                            <div class="pxl-icon--users icon-item h-btn-user <?php echo esc_attr($settings['style']) ?>">
                                <?php 
                                if (is_user_logged_in()) {
                                    $current_user = wp_get_current_user();
                                    $display_name = $current_user->display_name;
                                    ?>
                                    <ul class="pxl-user-account">
                                        <li><a href="<?php echo esc_url(wp_logout_url()); ?>"><?php echo esc_html__('Log Out', 'aimo'); ?></a></li>
                                    </ul>
                                    <?php 
                                } else {
                                    ?>
                                    <div class="pxl-is-not-login">
                                        <a href="javascript:void(0)" class="btn-sign-up"> 
                                            <span class="btn pxl-button-link btn-icon-box4">
                                                <i aria-hidden="true" class="flaticon flaticon-next"></i>
                                                <p><?php echo esc_html__('Signup', 'aimo');?></p>
                                            </span>
                                        </a>
                                    </div>
                                    <?php 
                                }
                                ?>
                            </div> 
                    </div>
                </a>
            </div>
        </div>
    </div>
    <?php if(!empty($settings['image']['id'])) : 
        $img = pxl_get_image_by_size( array(
            'attach_id'  => $settings['image']['id'],
            'thumb_size' => '400x453',
        ));
        $thumbnail = $img['thumbnail']; ?>
        <div class="pxl-image">
            <?php echo pxl_print_html($thumbnail); ?>
        </div>        
    <?php endif; ?>
</div>