<?php 
$title_item1 = $settings['title_item1'];
$content1 = $settings['content1'];
$button = $settings['button'];

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
?>

<div class="pxl-banner-edit pxl-banner-edit2<?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item-inner">
        <div class="pxl-contact">
            <div class="wrap-content">
                <div class="pxl-item--icon ">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
                <h4 class="pxl-item-title"><?php echo pxl_print_html($title_item1); ?></h4>
                <div class="pxl-item-content"><?php echo pxl_print_html($content1); ?></div>
                <a class="pxl-link" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>>
                    <div class="pxl-button-link">
                        <div class="pxl--btn-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="white">
                                <g clip-path="url(#clip0_74_1870)">
                                    <path d="M12.7598 19.9998C12.7103 19.9998 12.6607 19.9996 12.6106 19.9991C11.0694 19.9855 9.48851 19.5266 7.91205 18.635C6.6742 17.935 5.42992 16.9635 4.21383 15.7473C1.44276 12.9763 0.0252734 10.1643 0.000782083 7.38964C-0.0147642 5.63118 0.185072 3.07292 2.09149 1.16647C2.83642 0.421535 3.76576 0.00737034 4.70826 0.000300289L4.73334 0.000183105H4.73986C5.8806 0.000183105 6.93982 0.62434 7.50488 1.63032L8.14188 2.76438L8.15274 2.78699C8.47656 3.46158 8.63507 3.97972 8.66671 4.46705C8.71198 5.16417 8.48691 5.76743 7.99779 6.26018L6.22766 8.095C6.49077 8.82278 7.16407 10.392 8.44351 11.6742C9.71007 12.938 11.237 13.5827 11.9604 13.8363L13.7348 11.9947C14.232 11.4984 14.8219 11.2615 15.4873 11.2905C15.9985 11.3128 16.5374 11.4839 17.2346 11.8452L17.2578 11.8577L18.3699 12.4824C19.3778 13.0485 20.0024 14.1107 20 15.2544L19.9999 15.2819C19.9928 16.2215 19.5787 17.1508 18.8338 17.8957C18.0058 18.7237 16.9618 19.3133 15.7307 19.6482C14.8621 19.8845 13.8888 19.9998 12.7598 19.9998ZM4.73932 1.56262C4.73822 1.56262 4.73717 1.56262 4.73607 1.56262L4.71967 1.5627C4.19043 1.56669 3.64928 1.81832 3.19633 2.27127C1.70521 3.76239 1.5501 5.89867 1.56315 7.37581C1.58393 9.72646 2.84743 12.1713 5.31859 14.6425C7.81545 17.1394 10.2735 18.4159 12.6244 18.4367C14.0962 18.4498 16.2266 18.2932 17.7289 16.7908C18.1819 16.3379 18.4335 15.7968 18.4375 15.2672L18.4376 15.2483C18.4388 14.6728 18.1196 14.1338 17.6047 13.8446L16.5043 13.2264C15.4193 12.6665 15.1076 12.8338 14.8435 13.0955L12.4366 15.5939L11.9979 15.4839C11.8916 15.4573 9.37199 14.8083 7.33926 12.7795L7.3382 12.7785C5.31418 10.7505 4.61346 8.2007 4.5846 8.09312L4.47019 7.66638L6.88674 5.16167C7.11509 4.93285 7.29262 4.61462 6.75479 3.48529L6.14266 2.39548C5.85388 1.88156 5.3164 1.56262 4.73932 1.56262ZM17.2542 2.74598C15.4836 0.975342 13.1294 0.000222167 10.6253 0.000222167V1.56266C14.933 1.56266 18.4376 5.06722 18.4376 9.37487H20C20 6.87079 19.0249 4.51658 17.2542 2.74598ZM10.6253 6.24995V7.81239C11.4869 7.81239 12.1878 8.5133 12.1878 9.37483H13.7502C13.7502 7.65177 12.3484 6.24995 10.6253 6.24995ZM10.6253 3.12507V4.68751C13.2099 4.68751 15.3127 6.79024 15.3127 9.37483H16.8751C16.8751 5.92871 14.0715 3.12507 10.6253 3.12507Z"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_74_1870">
                                    <rect width="20" height="20" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </div>
                        <?php echo pxl_print_html($button); ?>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>