<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); ?>
<div class="pxl-counter pxl-counter2 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-counter--holder">
        <div class="pxl-counter--number <?php echo esc_attr($settings['shape_number']); ?>">
            <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
            <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
            <?php if(!empty($settings['suffix'])) : ?>
                <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
            <?php endif; ?>
            <span class="pxl-counter--plus"><?php echo pxl_print_html($settings['under_suffix']); ?></span>
        </div>
        <div class="pxl-content">
            <?php if(!empty($settings['title'])) : ?>
                <div class="pxl-counter--title"><?php echo pxl_print_html($settings['title']); ?></div>
            <?php endif; ?>
            <?php if(!empty($settings['desc'])) : ?>
                <div class="pxl-counter--desc"><?php echo pxl_print_html($settings['desc']); ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>