<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); ?>
<div class="pxl-counter-box pxl-counter-box1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-counter--holder">
        <div class="pxl-counter--number pxl-flex <?php echo esc_attr($settings['shape_number']); ?>">
            <div class="pxl-svg">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="url(#paint0_linear_1_408)">
                    <g clip-path="url(#clip0_1_408)">
                        <path d="M5.41772 6.58228L6.48681 7.65132L11.244 2.89413L11.244 24L12.756 24L12.756 2.89413L17.5132 7.65132L18.5822 6.58228L12 -2.87718e-07L5.41772 6.58228Z" />
                    </g>
                    <defs>
                        <linearGradient id="paint0_linear_1_408" x1="12" y1="-2.8772e-07" x2="12" y2="24" gradientUnits="userSpaceOnUse">
                        <stop stop-color="white"/>
                        <stop offset="1" stop-color="#999999" stop-opacity="0"/>
                        </linearGradient>
                        <clipPath id="clip0_1_408">
                        <rect width="24" height="24" fill="white" transform="translate(0 24) rotate(-90)"/>
                        </clipPath>
                    </defs>
                </svg>
            </div>
            <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
            <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
            <?php if(!empty($settings['suffix'])) : ?>
                <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
            <?php endif; ?>
            <span class="pxl-counter--plus"><?php echo pxl_print_html($settings['under_suffix']); ?></span>
        </div>
        <div class="pxl-content">
            <?php if(!empty($settings['title'])) : ?>
                <div class="pxl-counter--title"><?php echo pxl_print_html($settings['title']); ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>