<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
    <div class="pxl-details-box pxl-details-box1">
        <?php foreach ($settings['lists'] as $key => $value): 
            $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
            if ( ! empty( $value['link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                if ( $value['link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $value['link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
            <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                    <h6><?php echo pxl_print_html($value['title'])?></h6>
                    <span><?php echo pxl_print_html($value['text'])?></span>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>