<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): 
    $is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
    <div class="pxl-details-box pxl-details-box2">
        <?php foreach ($settings['lists'] as $key => $value): 
            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
            ?>
            <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                <h6 class="pxl-title">
                    <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                        <div class="pxl-item--icon">
                            <?php if ( $is_new ):
                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                            elseif(!empty($value['pxl_icon'])): ?>
                                <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php echo pxl_print_html($value['title'])?>
                </h6>
                <span class="pxl-text"><?php echo pxl_print_html($value['text'])?></span>
            </div>
        <?php endforeach; ?>
        <?php if ( ! empty( $settings['link']['url'] ) ) {
            $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

            if ( $settings['link']['is_external'] ) {
                $widget->add_render_attribute( 'link', 'target', '_blank' );
            }

            if ( $settings['link']['nofollow'] ) {
                $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
            } ?>
            <div class="pxl-item--readmore btn-icon-box4 btn"><?php echo esc_html__('Apply Now', 'aimo'); ?>
                <span class="pxl--btn-icon"><i aria-hidden="true" class="flaticon flaticon-next"></i></span>
                <a class="pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>></a>
            </div>
        <?php } ?>
    </div>
<?php endif; ?>