<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): 
    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
    $image_size1 = !empty($settings['img_size1']) ? $settings['img_size1'] : 'full'; ?>
    <div class="pxl-featured-image-box style1 <?php echo esc_attr($settings['style']); ?>">
        <?php foreach ($settings['lists'] as $key => $value): 
            $link_key = $widget->get_repeater_setting_key( 'item_link', 'value', $key );
            $image = isset($value['image']) ? $value['image'] : '';
            $image1 = isset($value['author_image']) ? $value['author_image'] : '';
            if ( ! empty( $value['item_link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                if ( $value['item_link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $value['item_link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
            <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                <a class="pxl-item--link" <?php echo implode( ' ', [ $link_attributes ] ); ?>></a>
                <?php if(!empty($image['id'])) { 
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $image_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];?>

                    <div class="pxl-item--image">
                        <?php echo wp_kses_post($thumbnail); ?>
                    </div>
                <?php } ?>                                      
                    <div class="pxl-item--holder ">
                        <h3 class="pxl-title">
                            <?php echo pxl_print_html($value['title'])?>
                        </h3>
                        <div class="pxl-desc">
                        <?php echo pxl_print_html($value['desc'])?>
                        </div>
                        <div class="pxl-footer-box">
                            <div class="pxl-author">
                                <?php if(!empty($image1['id'])) { 
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $image1['id'],
                                        'thumb_size' => $image_size1,
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail1 = $img['thumbnail'];?>

                                    <div class="pxl-item--image-author">
                                        <?php echo wp_kses_post($thumbnail1); ?>
                                    </div>
                                <?php } ?> 
                                <div class="pxl-author-name">
                                    <?php echo pxl_print_html($value['author_name'])?>
                            </div>   
                            </div>
                            <div class="pxl-date-tag">
                                <div class="pxl-date">
                                    <?php echo pxl_print_html($value['date'])?>
                                </div> 
                                <div class="pxl-tag">
                                    <?php echo pxl_print_html($value['tag'])?>
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>      
            <?php endforeach; ?>
        </div>
    <?php endif; ?>