
<div class="pxl-icon-text pxl-icon-text1 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if ( ! empty( $settings['link']['url'] ) ) {
            $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

            if ( $settings['link']['is_external'] ) {
                $widget->add_render_attribute( 'link', 'target', '_blank' );
            }

            if ( $settings['link']['nofollow'] ) {
                $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
            } ?>
            <a class="pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>></a>
        <?php } ?>
        <div class="pxl-item-wrap">
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon ">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon ">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
            <div class="pxl-item--meta">
                <h3 class="pxl-item--title">
                    <?php echo pxl_print_html($settings['text1']); ?>
                </h3>
            </div>
        </div>
    </div>
</div>