<?php
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }
    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}
$styleMappings = array(
    'style1' => 'displacements-01.jpg',
    'style2' => 'displacements-02.jpg',
    'style3' => 'displacements-03.jpg',
    'style4' => 'displacements-04.jpg',
    'style5' => 'displacements-05.jpg',
    'style6' => 'displacements-06.jpg',
    'style7' => 'displacements-07.jpg',
);
$imgds = isset($styleMappings[$settings['effect_style']]) ? $styleMappings[$settings['effect_style']] : '';
?>
<div class="pxl-image-effect pxl-image-effect1 <?php echo esc_attr($settings['image_effects']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" >
    <div class="pxl-item--inner">
        <div class="canvas"></div>
        <div class="item--image">            
            <?php if ( !empty($settings['image_front']['id']) ) : ?>
                <img src="<?php echo esc_url($settings['image_front']['url'])?>" class="image-front attachment-full" alt="image front" data-sampler="texture0">
            <?php endif; ?>
            <?php if ( !empty($settings['image_back']['id']) ) : ?>
                <img src="<?php echo esc_url($settings['image_back']['url'])?>" class="image-back attachment-full" alt="image back" data-sampler="texture1">
            <?php endif; ?>
            <?php if ( $settings['image_effects'] == 'normal' ) : ?>
                <img src='<?php echo esc_url( get_template_directory_uri().'/assets/img/'.$imgds ); ?>' class='map' alt='Image'>
            <?php endif; ?>            
        </div>
    </div>
</div>