<?php 
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
$img = pxl_get_image_by_size( array(
    'attach_id'  => $settings['img']['id'],
    'thumb_size' => $image_size,
    'class' => 'no-lazyload'
) );
$thumbnail = $img['thumbnail']; 
$is_new = \Elementor\Icons_Manager::is_migration_allowed(); 
?>
<div class="pxl-image-split pxl-image-split1">
    <div class="filler-space"></div>
    <div class="image-split-hold">
        <div class="containers full-width-height">
            <div class="pxl-content">
                <div class="pxl-width"></div>
            </div>
            <?php if(!empty($settings['img']['id'])) : 
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['img']['id'],
                    'thumb_size' => 'full',
                ));
                $thumbnail = $img['thumbnail']; 
                $thumbnail_url = $img['url'];?>
                <div class="bg-image " style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                </div>        
            <?php endif; ?>
        </div>
    </div>
    <div id="features" class="content-between-split pxl-width">
        <div class="sticky-in-between">
            <div class="pxl-heading">
                <div class="pxl-item--subtext">
                    <div class="sub-title">
                        <?php echo pxl_print_html($settings['sub_title'])?>
                    </div>
                </div>
                <h3 class="heading">
                    <?php echo pxl_print_html($settings['heading'])?>
                </h3>
            </div>
            <div class="pxl-list pxl-list1 ">
                <?php foreach ($settings['lists'] as $key => $value): 
                    $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                    $widget->add_render_attribute( $icon_key, [
                        'class' => $value['pxl_icon'],
                        'aria-hidden' => 'true',
                    ] );
                    $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
                    if ( ! empty( $value['link']['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                        if ( $value['link']['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $value['link']['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                    <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                        <div class="pxl-item--text el-empty">
                            <a class="pxl-link" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                            </a>
                            <div class="pxl-content-list">
                                <h4 class="pxl-title">
                                    <?php echo pxl_print_html($value['text'])?>
                                    <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                                        <div class="pxl-item--icon">
                                            <?php if ( $is_new ):
                                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                                            elseif(!empty($value['pxl_icon'])): ?>
                                                <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </h4>
                                <div class="pxl-desc">
                                    <?php echo pxl_print_html($value['desc'])?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php if ( ! empty( $settings['link1']['url'] ) ) {
                $widget->add_render_attribute( 'link1', 'href', $settings['link1']['url'] );

                if ( $settings['link1']['is_external'] ) {
                    $widget->add_render_attribute( 'link1', 'target', '_blank' );
                }

                if ( $settings['link1']['nofollow'] ) {
                    $widget->add_render_attribute( 'link1', 'rel', 'nofollow' );
                } ?>
                <a class="btn pxl-icon-active btn-block-inline  btn-gradient-rotate pxl-icon--right btn-text-parallax" <?php pxl_print_html($widget->get_render_attribute_string( 'link1' )); ?>>
                    <span class="pxl--btn-icon"><i aria-hidden="true" class="flaticon flaticon-next"></i></span>
                    <span class="pxl--btn-text"><?php echo pxl_print_html($settings['button'])?></span>
                </a>
            <?php } ?>
            
        </div>
    </div>
</div>
