<?php
$html_id = pxl_get_element_id($settings);
?>
<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): 
    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full'; ?>
    <div class="pxl-list-modern pxl-list-modern1">
        <h2 class="pxl-item--title <?php echo esc_attr($settings['pxl_animate2']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay2']); ?>ms">
            <?php echo esc_attr($settings['title']); ?>
        </h2>
        <div class="pxl-list--content">
            <div class="pxl-list--images">
                <div class="pxl-images--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <?php foreach ($settings['lists'] as $key => $value): 
                        $image = isset($value['image']) ? $value['image'] : '';
                        if(!empty($image['id'])) { 
                            $img = pxl_get_image_by_size(array(
                                'attach_id'  => $image['id'],
                                'thumb_size' => $image_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail'];
                            $thumbnail_url = $img['url'];
                            ?>
                            <div id="<?php echo esc_attr($html_id.'-'.$key); ?>" class="pxl-list--featured bg-image <?php if($key == '0') { echo 'pxl-list--first active'; } ?>" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                            </div>
                        <?php } 
                    endforeach; ?>
                </div>
            </div>
            <div class="pxl-list">
                <div class="pxl-namespace">
                    <div class="pxl-name">
                        <?php  echo esc_html__('Name', 'aimo')?>
                    </div>
                    <div class="pxl-right">
                        <div class="pxl-kind">
                            <?php  echo esc_html__('Kind', 'aimo')?>
                        </div>
                        <div class="pxl-year">
                            <?php  echo esc_html__('Year', 'aimo')?>
                        </div>
                    </div>
                </div>
                <?php foreach ($settings['lists'] as $key => $value): 
                    $image = isset($value['image']) ? $value['image'] : '';
                    $text = isset($value['text']) ? $value['text'] : '';
                    $name = isset($value['name']) ? $value['name'] : '';
                    $year = isset($value['year']) ? $value['year'] : '';
                    ?>
                    <div class="pxl--item <?php echo esc_attr($settings['pxl_animate3']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay3']); ?>ms" data-image="#<?php echo esc_attr($html_id.'-'.$key); ?>">
                        <div class="pxl-item-content">
                            <?php if(!empty($image['id'])) { 
                                $img = pxl_get_image_by_size(array(
                                    'attach_id'  => $image['id'],
                                    'thumb_size' => $image_size,
                                    'class' => 'no-lazyload',
                                ));
                                $thumbnail = $img['thumbnail'];
                                ?>
                                <div class="pxl-item--image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            <?php } ?>
                            <div class="pxl-item--text">
                                <?php echo pxl_print_html($text); ?>
                            </div>
                            <div class="pxl-right">
                                <div class="pxl-item-name">
                                    <?php echo pxl_print_html($name); ?>    
                                </div>
                                <div class="pxl-item-year">
                                    <?php echo pxl_print_html($year); ?>    
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>