<?php

$html_id = pxl_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = (int)$widget->get_setting('col_md', '');
if($col_md == 'custom') {
    $col_md = $widget->get_setting('col_md_custom', '');
}
$col_lg = (int)$widget->get_setting('col_lg', '');
if($col_lg == 'custom') {
    $col_lg = $widget->get_setting('col_lg_custom', '');
}
$col_xl = (int)$widget->get_setting('col_xl', '');
if($col_xl == 'custom') {
    $col_xl = $widget->get_setting('col_xl_custom', '');
}
$col_xxl = (int)$widget->get_setting('col_xxl', '');
if($col_xxl == 'custom') {
    $col_xxl = $widget->get_setting('col_xxl_custom', '');
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);

$img_size = $widget->get_setting('img_size');
$show_author = $widget->get_setting('show_author');
$show_comment = $widget->get_setting('show_comment');
$show_date = $widget->get_setting('show_date');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
$show_excerpt = $widget->get_setting('show_excerpt');
$num_words = $widget->get_setting('num_words');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_percolumnfill'           => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'            => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-slider pxl-post-carousel pxl-post-carousel1 pxl-blog-style1" <?php if($settings['drap'] !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'aimo'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                        $image_size = !empty($img_size) ? $img_size : '318x240';
                        foreach ($posts as $key => $post):
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $author = get_user_by('id', $post->post_author);
                        $current_user = wp_get_current_user();
                        $post_video_link = get_post_meta($post->ID, 'post_video_link', true);
                        ?>
                        <div class="pxl-swiper-slide ">
                            <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>">
                                <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                                    $img_id = get_post_thumbnail_id($post->ID);
                                    $img          = pxl_get_image_by_size( array(
                                        'attach_id'  => $img_id,
                                        'thumb_size' => $image_size
                                    ) );
                                    $thumbnail    = $img['thumbnail'];
                                    ?>
                                    <div class="pxl-post--featured hover-imge-effect2">
                                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                                        <?php if(!empty($post_video_link)) : ?>
                                            <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup style1"><i class="caseicon-play1"></i></a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="pxl-content">
                                    <?php
                                        $tags = get_the_tags($post->ID);

                                        if ($tags && !is_wp_error($tags)) {
                                            $first_tag = $tags[0]; 
                                            echo '<a href="' . esc_url(get_tag_link($first_tag->term_id)) . '">' . esc_html($first_tag->name) . '</a>';
                                        }
                                    ?>

                                    <h3 class="pxl-post--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                                    <div class="pxl-post--meta">
                                        <?php if($show_comment) : ?>
                                            <div class="pxl-item--comment pxl-mr-10">
                                                <i class="flaticon-chat text-gradient pxl-mr-7"></i>
                                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>#comments">
                                                    <?php echo comments_number(esc_html__('No Comments', 'aimo'),esc_html__('1 Comment', 'aimo'),esc_html__('% Comments', 'aimo')); ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($show_date == 'true'): ?>
                                            <div class="pxl-post--date pxl-mr-10">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="#3D3D3D">
                                                    <g clip-path="url(#clip0_1_655)">
                                                        <path d="M5.625 9.72656H4.375C4.05141 9.72656 3.78906 9.98891 3.78906 10.3125C3.78906 10.6361 4.05141 10.8984 4.375 10.8984H5.625C5.94859 10.8984 6.21094 10.6361 6.21094 10.3125C6.21094 9.98891 5.94859 9.72656 5.625 9.72656Z" />
                                                        <path d="M5.625 12.2266H4.375C4.05141 12.2266 3.78906 12.4889 3.78906 12.8125C3.78906 13.1361 4.05141 13.3984 4.375 13.3984H5.625C5.94859 13.3984 6.21094 13.1361 6.21094 12.8125C6.21094 12.4889 5.94859 12.2266 5.625 12.2266Z" />
                                                        <path d="M5.625 14.7266H4.375C4.05141 14.7266 3.78906 14.9889 3.78906 15.3125C3.78906 15.6361 4.05141 15.8984 4.375 15.8984H5.625C5.94859 15.8984 6.21094 15.6361 6.21094 15.3125C6.21094 14.9889 5.94859 14.7266 5.625 14.7266Z" />
                                                        <path d="M10.625 9.72656H9.375C9.05141 9.72656 8.78906 9.98891 8.78906 10.3125C8.78906 10.6361 9.05141 10.8984 9.375 10.8984H10.625C10.9486 10.8984 11.2109 10.6361 11.2109 10.3125C11.2109 9.98891 10.9486 9.72656 10.625 9.72656Z" />
                                                        <path d="M10.625 12.2266H9.375C9.05141 12.2266 8.78906 12.4889 8.78906 12.8125C8.78906 13.1361 9.05141 13.3984 9.375 13.3984H10.625C10.9486 13.3984 11.2109 13.1361 11.2109 12.8125C11.2109 12.4889 10.9486 12.2266 10.625 12.2266Z" />
                                                        <path d="M10.625 14.7266H9.375C9.05141 14.7266 8.78906 14.9889 8.78906 15.3125C8.78906 15.6361 9.05141 15.8984 9.375 15.8984H10.625C10.9486 15.8984 11.2109 15.6361 11.2109 15.3125C11.2109 14.9889 10.9486 14.7266 10.625 14.7266Z" />
                                                        <path d="M15.625 9.72656H14.375C14.0514 9.72656 13.7891 9.98891 13.7891 10.3125C13.7891 10.6361 14.0514 10.8984 14.375 10.8984H15.625C15.9486 10.8984 16.2109 10.6361 16.2109 10.3125C16.2109 9.98891 15.9486 9.72656 15.625 9.72656Z" />
                                                        <path d="M15.625 12.2266H14.375C14.0514 12.2266 13.7891 12.4889 13.7891 12.8125C13.7891 13.1361 14.0514 13.3984 14.375 13.3984H15.625C15.9486 13.3984 16.2109 13.1361 16.2109 12.8125C16.2109 12.4889 15.9486 12.2266 15.625 12.2266Z" />
                                                        <path d="M15.625 14.7266H14.375C14.0514 14.7266 13.7891 14.9889 13.7891 15.3125C13.7891 15.6361 14.0514 15.8984 14.375 15.8984H15.625C15.9486 15.8984 16.2109 15.6361 16.2109 15.3125C16.2109 14.9889 15.9486 14.7266 15.625 14.7266Z" />
                                                        <path d="M18.2422 2.53906H16.8359V1.5625C16.8359 1.23891 16.5736 0.976562 16.25 0.976562C15.9264 0.976562 15.6641 1.23891 15.6641 1.5625V2.53906H10.5859V1.5625C10.5859 1.23891 10.3236 0.976562 10 0.976562C9.67641 0.976562 9.41406 1.23891 9.41406 1.5625V2.53906H4.33594V1.5625C4.33594 1.23891 4.07359 0.976562 3.75 0.976562C3.42641 0.976562 3.16406 1.23891 3.16406 1.5625V2.53906H1.75781C0.788555 2.53906 0 3.32762 0 4.29688V17.2656C0 18.2349 0.788555 19.0234 1.75781 19.0234H18.2422C19.2114 19.0234 20 18.2349 20 17.2656C20 16.8874 20 4.62598 20 4.29688C20 3.32762 19.2114 2.53906 18.2422 2.53906ZM1.17188 4.29688C1.17188 3.97379 1.43473 3.71094 1.75781 3.71094H3.16406V4.6875C3.16406 5.01109 3.42641 5.27344 3.75 5.27344C4.07359 5.27344 4.33594 5.01109 4.33594 4.6875V3.71094H9.41406V4.6875C9.41406 5.01109 9.67641 5.27344 10 5.27344C10.3236 5.27344 10.5859 5.01109 10.5859 4.6875V3.71094H15.6641V4.6875C15.6641 5.01109 15.9264 5.27344 16.25 5.27344C16.5736 5.27344 16.8359 5.01109 16.8359 4.6875V3.71094H18.2422C18.5653 3.71094 18.8281 3.97379 18.8281 4.29688V6.60156H1.17188V4.29688ZM18.2422 17.8516H1.75781C1.43473 17.8516 1.17188 17.5887 1.17188 17.2656V7.77344H18.8281V17.2656C18.8281 17.5887 18.5653 17.8516 18.2422 17.8516Z" />
                                                    </g>
                                                    <defs>
                                                        <clipPath id="clip0_1_655">
                                                        <rect width="20" height="20" fill="white"/>
                                                        </clipPath>
                                                    </defs>
                                                </svg>
                                                <?php echo get_the_date('F', $post->ID); ?>,<?php echo get_the_date('y', $post->ID); ?>        
                                            </div>
                                        <?php endif; ?>
                                        <?php if($show_author == 'true'): ?>
                                            <div class="pxl-post--author pxl-mr-10">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="#3D3D3D">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.99984 2.29102C5.74265 2.29102 2.2915 5.74216 2.2915 9.99935C2.2915 14.2565 5.74265 17.7077 9.99984 17.7077C14.257 17.7077 17.7082 14.2565 17.7082 9.99935C17.7082 5.74216 14.257 2.29102 9.99984 2.29102ZM1.0415 9.99935C1.0415 5.0518 5.05229 1.04102 9.99984 1.04102C14.9474 1.04102 18.9582 5.0518 18.9582 9.99935C18.9582 14.9469 14.9474 18.9577 9.99984 18.9577C5.05229 18.9577 1.0415 14.9469 1.0415 9.99935Z" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.99292 6.45703C9.18509 6.45703 8.53167 7.11079 8.53167 7.91536C8.53167 8.71995 9.18509 9.3737 9.99292 9.3737C10.8008 9.3737 11.4543 8.71995 11.4543 7.91536C11.4543 7.11079 10.8008 6.45703 9.99292 6.45703ZM7.28164 7.91536C7.28164 6.41876 8.49634 5.20703 9.99292 5.20703C11.4895 5.20703 12.7043 6.41876 12.7043 7.91536C12.7043 9.41195 11.4895 10.6237 9.99292 10.6237C8.49634 10.6237 7.28164 9.41195 7.28164 7.91536ZM13.2904 14.5889C11.5853 12.7389 8.41075 12.8074 6.70205 14.5969C6.46369 14.8466 6.06806 14.8558 5.8184 14.6174C5.56874 14.379 5.55959 13.9834 5.79795 13.7338C7.97545 11.4531 11.9868 11.3299 14.2096 13.7418C14.4435 13.9956 14.4274 14.391 14.1736 14.6249C13.9198 14.8589 13.5243 14.8428 13.2904 14.5889Z" />
                                                </svg>
                                                <?php the_author_posts_link(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($show_excerpt == 'true'): ?>
                                        <div class="pxl-post--content">
                                            <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($show_button == 'true') : ?>
                                        <div class="pxl-post--button">
                                            <a class="btn" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                                <?php if(!empty($button_text)) {
                                                    echo esc_attr($button_text);
                                                } else {
                                                    echo esc_html__('Read More', 'aimo');
                                                } ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div> 
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots-wrap">
                    <div class="pxl-swiper-dots style-1"></div>
                </div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php endif; ?>