<div class="pxl-pricing pxl-pricing1 <?php echo pxl_print_html($settings['_style'])?>">
    <?php if (!empty($settings['popular'])) : ?>
        <div class="pxl-pricing--absolute">
            <span><?php echo esc_html($settings['popular']); ?></span>
        </div>
    <?php endif; ?>
    <?php if (!empty($settings['popular'])) : ?>
        <div class="pxl-pricing--top">
            <span><?php echo esc_html($settings['popular']); ?></span>
        </div>
    <?php endif; ?>
    <div class="pxl-pricing--price">
        <span class="pxl-pricing--currency"><?php echo esc_html($settings['currency']); ?></span>
        <span class="pxl-price"><?php echo esc_html($settings['price']); ?></span>
        <span class="pxl-time"><?php echo esc_html($settings['time']); ?></span>
    </div>
    <?php if ( ! empty( $settings['btn_text'] ) ) {
        $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

        if ( $settings['btn_link']['is_external'] ) {
            $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
        }

        if ( $settings['btn_link']['nofollow'] ) {
            $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
        } ?>
        <div class="pxl-pricing--button">
            <a class="btn" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><span><?php echo esc_html($settings['btn_text']); ?></span><i class="flaticon-right-arrow-1 pxl-ml-18"></i></a>
        </div>
    <?php } ?>
    <?php if(isset($settings['feature']) && !empty($settings['feature']) && count($settings['feature'])): ?>
        <ul class="pxl-pricing--feature">
            <?php
                foreach ($settings['feature'] as $key => $link):
                    $feature_text = $widget->parse_text_editor( $link['feature_text'] );
                    $feature_active = $widget->parse_text_editor( $link['feature_active'] );  ?>
                    <li>
                        <i aria-hidden="true" class="fas fa-check"></i>
                        <?php if($feature_active == 'no') { echo '<del>'; } ?>
                        <?php echo pxl_print_html($feature_text); ?>
                        <?php if($feature_active == 'no') { echo '</del>'; } ?>
                    </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if (!empty($settings['icon_image']) && isset($settings['icon_image']['id'])) : ?>
        <div class="pxl-item--image ">
            <?php 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '295x125';
            $img_icon  = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['icon_image']['id'],
                    'thumb_size' => $image_size,
                ) );
            if (!empty($img_icon) && isset($img_icon['thumbnail'])) {
                $thumbnail_icon = $img_icon['thumbnail'];
                echo pxl_print_html($thumbnail_icon);
            }
            ?>
        </div>
    <?php endif; ?>

</div>
    