<?php
$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-process pxl-process1">
    <div class="pxl-heading">
        <div class="pxl-item--subtext">
            <div class="sub-title">
                <?php echo pxl_print_html($settings['sub_title'])?>
            </div>
        </div>
        <h3 class="heading">
            <?php echo pxl_print_html($settings['heading'])?>
        </h3>
    </div>
    <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): 
        $image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full'; ?>
        <div class="pxl-list-modern1">
            <div class="pxl-list--content">

                <div class="pxl-list">
                    <div class="pxl-bacground-gradien">
                        <div class="gradien1"></div>
                        <div class="gradien2"></div>
                        <div class="gradien3"></div>
                        <div class="img-star"></div>
                    </div>
                    <?php foreach ($settings['lists'] as $key => $value): 
                        $image = isset($value['image']) ? $value['image'] : '';
                        $text = isset($value['text']) ? $value['text'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        ?>
                        <div class="pxl--item <?php echo esc_attr($settings['pxl_animate3']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay3']); ?>ms" data-image="#<?php echo esc_attr($html_id.'-'.$key); ?>">
                            <div class="pxl-item-content">
                                <?php if(!empty($image['id'])) { 
                                    $img = pxl_get_image_by_size(array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => $image_size,
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail = $img['thumbnail'];
                                    ?>
                                    <div class="pxl-item--image">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </div>
                                <?php } ?>
                               <div class="pxl-content">
                                    <div class="pxl-item--text">
                                        <?php echo pxl_print_html($text); ?>
                                    </div>
                                    <div class="pxl-item-desc">
                                        <?php echo pxl_print_html($desc); ?>    
                                    </div>
                               </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <?php if ( ! empty( $settings['link1']['url'] ) ) {
                        $widget->add_render_attribute( 'link1', 'href', $settings['link1']['url'] );

                        if ( $settings['link1']['is_external'] ) {
                            $widget->add_render_attribute( 'link1', 'target', '_blank' );
                        }

                        if ( $settings['link1']['nofollow'] ) {
                            $widget->add_render_attribute( 'link1', 'rel', 'nofollow' );
                        } ?>
                        <a class="btn pxl-icon-active btn-block-inline  btn-gradient-rotate pxl-icon--right btn-text-parallax" <?php pxl_print_html($widget->get_render_attribute_string( 'link1' )); ?>>
                            <span class="pxl--btn-icon"><i aria-hidden="true" class="flaticon flaticon-next"></i></span>
                            <span class="pxl--btn-text"><?php echo pxl_print_html($settings['button'])?></span>
                        </a>
                    <?php } ?>
            
                </div>
                <div class="pxl-list--images">
                    <div class="pxl-images--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                        <?php foreach ($settings['lists'] as $key => $value): 
                            $image = isset($value['image']) ? $value['image'] : '';
                            if(!empty($image['id'])) { 
                                $img = pxl_get_image_by_size(array(
                                    'attach_id'  => $image['id'],
                                    'thumb_size' => $image_size,
                                    'class' => 'no-lazyload',
                                ));
                                $thumbnail = $img['thumbnail'];
                                $thumbnail_url = $img['url'];
                                ?>
                                <div id="<?php echo esc_attr($html_id.'-'.$key); ?>" class="pxl-list--featured bg-image <?php if($key == '0') { echo 'pxl-list--first active'; } ?>" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                                </div>
                            <?php } 
                        endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>