<?php if(isset($settings['lists_layout_3']) && !empty($settings['lists_layout_3']) && count($settings['lists_layout_3'])): 
    $is_new = \Elementor\Icons_Manager::is_migration_allowed();
    $image_size2 = !empty($settings['img_size_lo21']) ? $settings['img_size_lo21'] : '88x88'; ?>
    <div class="pxl-process pxl-process3">
        <?php foreach ($settings['lists_layout_3'] as $key => $value): 
            $link_key = $widget->get_repeater_setting_key( 'item_link', 'value', $key );
            $image = isset($value['image']) ? $value['image'] : '';
            $image1 = isset($value['image_ovelay']) ? $value['image_ovelay'] : '';
            $pxl_icon = isset($value['pxl_icon']) ? $value['pxl_icon'] : '';
            if ( ! empty( $value['item_link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                if ( $value['item_link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $value['item_link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
            <div class="pxl--item elementor-repeater-item-<?php echo esc_attr($value['_id']. ' ' .$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                <a class="pxl-item--link" <?php echo implode( ' ', [ $link_attributes ] ); ?>></a>                                    
                <div class="pxl-item--holder ">
                    <h3 class="pxl-item--text">
                        <?php echo pxl_print_html($value['title'])?>
                    </h3>
                    <?php if(!empty($image['id'])) { 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => $image_size2,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];?>

                        <div class="pxl-item--image">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php } ?>  
                    <div class="pxl-item-desc">
                        <?php echo pxl_print_html($value['desc'])?>
                    </div>
                </div>
               
                <div class="pxl-icon">
                    <?php if ( $is_new ):
                        \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                    elseif(!empty($value['pxl_icon'])): ?>
                        <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                    <?php endif; ?>
                </div>   
                </div>
            <?php endforeach; ?>
    </div>
    <?php endif; ?>