<?php
$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class=" pxl-solution-carousel pxl-solution-carousel1 <?php echo esc_attr($settings['style_l1']); ?>">
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                        $link_key = $widget->get_repeater_setting_key( 'item_link', 'value', $key );
                        if ( ! empty( $value['item_link']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                            if ( $value['item_link']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['item_link']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                        <div class="pxl-item">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-icon">
                                    <?php if ( $is_new ):
                                        \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                                    elseif(!empty($value['pxl_icon'])): ?>
                                        <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="pxl-item--meta">
                                    <h5 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h5>
                                </div>
                                <a class="pxl-link" <?php echo implode( ' ', [ $link_attributes ] ); ?>></a>
                                <div class="pxl-button">
                                <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    <i aria-hidden="true" class="flaticon flaticon-next"></i>
                                </a>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
        
    </div>
<?php endif; ?>
