<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', 1);
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pagination_type1 = $widget->get_setting('pagination_type1', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'pagination_type1'               => $pagination_type1,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed,

];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): 
    $dots = (string)count($settings['testimonial']);
    ?>

    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel2 <?php echo esc_attr($settings['style_l1']); ?>" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'aimo'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position1 = isset($value['position1']) ? $value['position1'] : '';
                        $position2 = isset($value['position2']) ? $value['position2'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        $icon_image = isset($value['icon_image']) ? $value['icon_image'] : '';
                        $style_star = isset($value['style_star']) ? $value['style_star'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
                        if ( ! empty( $value['link']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                            if ( $value['link']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['link']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key ); 
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <a class="pxl--link" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                </a>
                                <div class="pxl-item--meta">
                                    <h5 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h5>
                                    <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                                    <?php if($settings['style_l1'] == 'style-2') : ?>
                                        <div class="pxl-item--rating  pxl-screen--lg">
                                            <div class="pxl-item--star pxl-item--flexnw pxl-item--<?php echo esc_attr( $style_star ); ?>">
                                                <i aria-hidden="true" class="fas fa-star"></i>
                                                <i aria-hidden="true" class="fas fa-star"></i>
                                                <i aria-hidden="true" class="fas fa-star"></i>
                                                <i aria-hidden="true" class="fas fa-star"></i>
                                                <i aria-hidden="true" class="fas fa-star"></i>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="pxl-item--holder pxl-item--flexnw">
                                    <?php if(!empty($image['id'])) { 
                                        $img = pxl_get_image_by_size( array(
                                            'attach_id'  => $image['id'],
                                            'thumb_size' => 'full',
                                            'class' => 'no-lazyload',
                                        ));
                                        $thumbnail = $img['thumbnail'];?>
                                        <div class="pxl-item-content">
                                            <div class="pxl-item--avatar pxl-mr-18">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                            <div class="pxl-item--position el-empty">
                                                <span class="pxl-title"><?php echo pxl_print_html($position1); ?></span>
                                                <span class="pxl-position"><?php echo pxl_print_html($position2); ?></span>
                                            </div>
                                        </div>
                                        <div class="pxl-quote">
                                            <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                viewBox="0 0 298.667 298.667" style="enable-background:new 0 0 298.667 298.667;" xml:space="preserve">
                                                <g>
                                                    <g>
                                                        <g>
                                                            <polygon points="0,170.667 64,170.667 21.333,256 85.333,256 128,170.667 128,42.667 0,42.667 			"/>
                                                            <polygon points="170.667,42.667 170.667,170.667 234.667,170.667 192,256 256,256 298.667,170.667 298.667,42.667"/>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                    <?php } ?>
                                </div>
                                <a class="pxl-icon-link" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    <i aria-hidden="true" class="flaticon flaticon-next"></i>
                                </a>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div class="pxl-slide-transition">
            <div class="pxl-swiper-dot">
                <?php if($pagination !== false): ?>
                    <div class="pxl-item--fraction">
                        <span class="pxl-item--fraction-active"></span>
                        <span class="pxl-item--fraction-sum">
                            <?php echo esc_html('/ '.$dots); ?>
                        </span>
                    </div>
                    <div class="pxl-swiper-dots style-1"></div>
                <?php endif; ?>
                <?php if($arrows !== false): ?>
                    <div class="pxl-swiper-arrow-wrap style-1">
                        <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-cursor--cta"><i aria-hidden="true" class="far fa-angle-left"></i></div>
                        <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-cursor--cta"><i aria-hidden="true" class="far fa-angle-right"></i></div>
                    </div>
                <?php endif; ?>
            </div>  
        </div>                                
    </div>
<?php endif; ?>
