<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class='pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel4 <?php echo esc_attr($settings['style_l1']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>'
    data-wow-delay='<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms'
    <?php if ($drap !== false) : ?>
        data-cursor-drap='<?php echo esc_attr__('DRAG', 'aimo'); ?>'
    <?php endif; ?>>
        <div class="pxl-image">
            <?php if(!empty($settings['image1']['id'])) : 
                $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '274x274'; 
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['image1']['id'],
                    'thumb_size' => $image_size,
                ));
                $thumbnail = $img['thumbnail'];
                ?>
                <div class="pxl-item--imgprimary">
                    <?php echo pxl_print_html($thumbnail); ?>
                </div>
            <?php endif; ?>
            <div class="pxl-content">
                <div class="pxl-title"><?php echo esc_html($settings['title_']); ?></div>
                <div class="pxl-desc"><?php echo esc_html($settings['position_']); ?></div>
            </div>
        </div>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $style_star = isset($value['style_star']) ? $value['style_star'] : '';
                        $position1 = isset($value['position1']) ? $value['position1'] : '';
                        $position2 = isset($value['position2']) ? $value['position2'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        ?>
                        <div class="pxl-swiper-slide ">
                            <div class="pxl-item--inner ">
                                <div class="pxl-item--holder pxl-item--flexnw">
                                    <div class="pxl-item--meta">
                                        <?php if($settings['style_l1'] == 'style-2') : ?>
                                            <div class="pxl-item--rating  pxl-screen--lg">
                                                <div class="pxl-item--star pxl-item--flexnw pxl-item--<?php echo esc_attr( $style_star ); ?>">
                                                    <div class="pxl-star--show">
                                                        <i aria-hidden="true" class="fas fa-star"></i>
                                                        <i aria-hidden="true" class="fas fa-star"></i>
                                                        <i aria-hidden="true" class="fas fa-star"></i>
                                                        <i aria-hidden="true" class="fas fa-star"></i>
                                                        <i aria-hidden="true" class="fas fa-star"></i>
                                                    </div>
                                                    <div class="pxl-star--hide">
                                                        <i aria-hidden="true" class="far fa-star"></i>
                                                        <i aria-hidden="true" class="far fa-star"></i>
                                                        <i aria-hidden="true" class="far fa-star"></i>
                                                        <i aria-hidden="true" class="far fa-star"></i>
                                                        <i aria-hidden="true" class="far fa-star"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                                    </div>
                                    <?php if(!empty($image['id'])) { 
                                        $img = pxl_get_image_by_size( array(
                                            'attach_id'  => $image['id'],
                                            'thumb_size' => '64x64',
                                            'class' => 'no-lazyload',
                                        ));
                                        $thumbnail = $img['thumbnail'];?>
                                        <div class="pxl-item-content">
                                            <div class="pxl-item--avatar pxl-mr-18">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                            <div class="pxl-item--position el-empty">
                                                <span class="pxl-title"><?php echo pxl_print_html($position1); ?></span>
                                                <span class="pxl-position"><?php echo pxl_print_html($position2); ?></span>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
        <div class="pxl-swiper-dot">
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>
            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-cursor--cta">
                        <i class="caseicon-angle-arrow-left rtl-icon"></i>
                        <div><?php echo esc_html__('Prev', 'aimo'); ?></div> 
                    </div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-cursor--cta">
                        <div><?php echo esc_html__('Next', 'aimo'); ?></div> 
                        <i aria-hidden="true" class="flaticon flaticon-next-1"></i>
                    </div>
                </div>
            <?php endif; ?>
        </div>                                  
    </div>
<?php endif; ?>
