<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); ?>
<div class="pxl--user-count-widget pxl--user-count-widget1  <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-background" >
        <?php if(!empty($settings['banner_image01']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size01'] : 'full'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['banner_image01']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail01 = $img['thumbnail'];
            $thumbnail_url = $img['url'];
            ?>
            <div class="pxl-background bg-image"style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);"></div>
        <?php endif; ?>
    </div>
    <div class="pxl-counter--holder">
        <div class="pxl-counter--number <?php echo esc_attr($settings['shape_number']); ?>">
            <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
            <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
            <?php if(!empty($settings['suffix'])) : ?>
                <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
            <?php endif; ?>
            <span class="pxl-counter--plus"><?php echo pxl_print_html($settings['under_suffix']); ?></span>
        </div>
        <div class="pxl-content">
            <?php if(!empty($settings['title'])) : ?>
                <div class="pxl-counter--title"><?php echo pxl_print_html($settings['title']); ?></div>
            <?php endif; ?>
            <?php if(!empty($settings['desc'])) : ?>
                <div class="pxl-counter--desc"><?php echo pxl_print_html($settings['desc']); ?></div>
            <?php endif; ?>
        </div>
        <div class="pxl-item-inner">
            <div class="pxl-item--images el-empty">
                <?php foreach ($settings['images'] as $key => $value): 
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $value['id'],
                        'thumb_size' => 'full',
                    ));
                    $thumbnail = $img['thumbnail'];
                    ?>
                    <div class="pxl-item--img">
                        <?php echo wp_kses_post($thumbnail); ?>
                    </div>
                <?php endforeach; ?>
                <div class="pxl-item--title"><?php echo pxl_print_html($settings['title-image']); ?></div>
            </div>
        </div>
        <div class="pxl-button">
            <?php if ( ! empty( $settings['link']['url'] ) ) {
                $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

                if ( $settings['link']['is_external'] ) {
                    $widget->add_render_attribute( 'link', 'target', '_blank' );
                }

                if ( $settings['link']['nofollow'] ) {
                    $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
                } ?>
                <a class="pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>>
                    <div class="pxl-item--icon">
                        <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                            <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                        <?php else : ?>
                            <i aria-hidden="true" class="flaticon flaticon-next"></i>
                        <?php endif; ?>
                    </div>
                </a>

            <?php } ?>
        </div>
    </div>
</div>