<?php
// Register Icon Box Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_client_review',
        'title' => esc_html__('Case Client Review', 'aimo' ),
        'icon' => 'eicon-blockquote',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'elementor-waypoints',
            'jquery-numerator',                    
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-1',
                            'options' => [
                                'style-1' => esc_html__('(Default)', 'aimo' ),
                                'style-2' => esc_html__('Style2', 'aimo' ),
                                'style-3' => esc_html__('Style Used For Cite', 'aimo' ),
                            ],
                        ),
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => '_color',
                            'label' => esc_html__( 'Color Cite', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-client-review1 .pxl-item--meta .pxl-item--title cite' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'tt_color',
                            'label' => esc_html__( 'Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-client-review1 .pxl-item--meta .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-client-review1 .pxl-item--meta .pxl-item--title',
                        ),
                        array(
                            'name' => 'images',
                            'label' => esc_html__('Images', 'aimo'),
                            'type' => \Elementor\Controls_Manager::GALLERY,
                            'label_block' => true,
                        ),
                    ),
                ),
                aimo_widget_animation_settings(),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);