<?php
// Register Icon Box Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon_light_dark',
        'title' => esc_html__('Case Icon Light Dark', 'aimo' ),
        'icon' => 'eicon-icon-box',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        
                    ),
                ),
                array(
                    'name' => 'section_style_text',
                    'label' => esc_html__('Style', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(                  
                        array(
                            'name'         => 'btn_gradient',
                            'label' => esc_html__( 'Background Type', 'aimo' ),
                            'type'         => \Elementor\Group_Control_Background::get_type(),
                            'control_type' => 'group',
                            'types' => [ 'gradient' ],
                            'selector'     => '{{WRAPPER}} .pxl-icon-dark-light1 .pxl-item-wrap',
                        ),
                        array(
                            'name' => 'text_color2',
                            'label' => esc_html__('Icon Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-dark-light1 svg' => 'fill: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                aimo_widget_animation_settings(),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);