<?php
// Register Icon Box Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon_text',
        'title' => esc_html__('Case Icon Text', 'aimo' ),
        'icon' => 'eicon-icon-box',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Layout', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '1' => 'Layout 1',
                                '2' => 'Layout 2',
                            ],
                            'default' => '1',
                        ),
                        array(
                            'name' => 'text1',
                            'label' => esc_html__('Text Link', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'text2',
                            'label' => esc_html__('Desc', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'label_block' => true,
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                        array(
                            'name' => 'icon_type',
                            'label' => esc_html__('Icon Type', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'icon' => 'Icon',
                                'image' => 'Image',
                            ],
                            'default' => 'icon',
                        ),
                        array(
                            'name' => 'pxl_icon',
                            'label' => esc_html__('Icon', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                            'condition' => [
                                'icon_type' => 'icon',
                            ],
                        ),
                        array(
                            'name' => 'icon_image',
                            'label' => esc_html__( 'Icon Image', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'icon_type' => 'image',
                            ],
                        ),
                        array(
                            'name' => 'wg_max_width',
                            'label' => esc_html__('Widget Max Width', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_box',
                    'label' => esc_html__('Style Box 8', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'style' => ['style-8','style-9'],
                    ],
                    'controls' => array(
                        array(
                            'name'  => 'heading_background_icon',
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'label' => esc_html__( 'Background Icon Settings', 'aimo' ),
                            'separator' => 'before', 
                        ),
                        array(
                            'name'         => 'icon_gradient',
                            'label' => esc_html__( 'Background Type', 'aimo' ),
                            'type'         => \Elementor\Group_Control_Background::get_type(),
                            'control_type' => 'group',
                            'types' => [ 'gradient' ],
                            'selector'     => '{{WRAPPER}} .pxl-icon-text1 .pxl-item--icon',
                        ),
                        array(
                            'name'  => 'heading_background_box',
                            'type'  => \Elementor\Controls_Manager::HEADING,
                            'label' => esc_html__( 'Color Border Settings', 'aimo' ),
                            'separator' => 'before', 
                        ),
                        array(
                            'name'         => 'border_gradient',
                            'label' => esc_html__( 'Background Type', 'aimo' ),
                            'type'         => \Elementor\Group_Control_Background::get_type(),
                            'control_type' => 'group',
                            'types' => [ 'gradient' ],
                            'selector'     => '{{WRAPPER}} .pxl-icon-text1 .pxl-item--inner::before',
                            'separator' => 'after',
                        ),
                    )
                ),
                array(
                    'name' => 'section_style_text',
                    'label' => esc_html__('Style', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'icon_space',
                            'label' => esc_html__('Spacer (Right)', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => ['px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'default' => [
                                'size' => 6,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'btn_bg_color_1',
                            'label' => esc_html__( 'Border Color - 1', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text1.style-6 .pxl-item--inner::after' => '--primary-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'style' => ['style-6'],
                            ],
                        ),
                        array(
                            'name' => 'btn_bg_color_2',
                            'label' => esc_html__( 'Border Color - 2', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text1.style-6 .pxl-item--inner::after' => '--secondary-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'style' => ['style-6'],
                            ],
                        ),
                        array(
                            'name' => 'btn_bg_color_3',
                            'label' => esc_html__( 'Border Color - 3', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text1.style-6 .pxl-item--inner::after' => '--third-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'style' => ['style-6'],
                            ],
                        ),                        
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style-default' => 'Style Default',
                                'style-1' => 'Style 1',
                                'style-2' => 'Style 2',
                                'style-3' => 'Style 3',
                                'style-4' => 'Style 4',
                                'style-5' => 'Style 5',
                                'style-6' => 'Style 6',
                                'style-7' => 'Style 7',
                                'style-8' => 'Style 8',
                                'style-9' => 'Style 9',
                            ],
                            'default' => 'style-1',
                            'condition' => [
                                'layout' => '1',
                            ],
                        ),
                        array(
                            'name' => 'style1',
                            'label' => esc_html__('Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style-1' => 'Style 1',
                                'style-2' => 'Style 2',
                                'style-3' => 'Style 3',
                                'style-4' => 'Style 4',
                                'style-5' => 'Style 5',
                            ],
                            'default' => 'style-1',
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Title Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-icon-text .pxl-item--title',
                        ),
                        array(
                            'name' => 'text_color1',
                            'label' => esc_html__('Title Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_typography1',
                            'label' => esc_html__('Text Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-icon-text .pxl-item--desc',
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'text_color2',
                            'label' => esc_html__('Text Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--desc' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_icon',
                    'label' => esc_html__('Icon', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon i' => 'color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;',
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon svg' => 'fill: {{VALUE}} !important;text-fill-color: {{VALUE}} !important;-webkit-text-fill-color: {{VALUE}} !important;background-image: none !important;',
                            ],
                            'condition' => [
                                'icon_type' => 'icon',
                                
                            ],
                        ),
                        array(
                            'name' => 'icon_bg_color',
                            'label' => esc_html__('Bg Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text1 .pxl-item--icon' => 'background: {{VALUE}};',
                            ],
                            'condition' => [
                                'icon_type' => 'icon',
                                'style' => ['!' => 'style-7'],
                            ],
                        ),
                        array(
                            'name' => 'icon_bg_color1',
                            'label' => esc_html__('Bg Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text1 .pxl-item--icon::before' => 'background: {{VALUE}};',
                                '{{WRAPPER}} .pxl-icon-text1 .pxl-item--icon::after' => 'background: {{VALUE}};',
                            ],
                            'condition' => [
                                'icon_type' => 'icon',
                                'style' => 'style-7',
                            ],
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Size', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon svg' => 'width: {{SIZE}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'icon_type' => 'icon',
                            ],
                        ),
                        array(
                            'name' => 'box_width',
                            'label' => esc_html__('Box Width', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'style' => ['style-4'],
                            ],
                        ),
                        array(
                            'name' => 'box_height',
                            'label' => esc_html__('Box Height', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'style' => ['style-4'],
                            ],
                        ),
                        array(
                            'name' => 'box_radius',
                            'label' => esc_html__('Border Radius', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'condition' => [
                                'style' => ['style-4'],
                            ],
                        ),
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'aimo' ),
                                'solid' => esc_html__( 'Solid', 'aimo' ),
                                'double' => esc_html__( 'Double', 'aimo' ),
                                'dotted' => esc_html__( 'Dotted', 'aimo' ),
                                'dashed' => esc_html__( 'Dashed', 'aimo' ),
                                'groove' => esc_html__( 'Groove', 'aimo' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon' => 'border-style: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                            'responsive' => true,
                        ),
                        array(
                            'name' => 'box_color_border',
                            'label' => esc_html__( 'Box Color Border', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon-text .pxl-item--icon' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                        ),
                    ),
                ),
                aimo_widget_animation_settings(),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);