<?php
// Register Button Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon_user',
        'title' => esc_html__('Case User', 'aimo' ),
        'icon' => 'eicon-user',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style1',
                            'options' => [
                                'style1' => esc_html__('Style 1 (Popup)', 'aimo' ),
                            ],
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-user-account a' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'bg_btn_color',
                            'label' => esc_html__(' Button Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-sign-up' => 'background: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'text_placeholder',
                            'label' => esc_html__('Text Placeholder', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'style' => ['style2', 'style3'],
                            ],
                        ),
                        array(
                            'name' => 'text_button',
                            'label' => esc_html__('Text Button', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'style' => 'style3',
                            ],
                        ),
                        array(
                            'name' => 'quick_user',
                            'label' => esc_html__('Quick User', 'aimo'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ content }}}',
                            'condition' => [
                                'style' => 'style3',
                            ],
                        ),
                        array(
                            'name' => 'post_type',
                            'label' => esc_html__('User Post Type', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'options' => [
                                '' => esc_html__('All', 'aimo' ),
                                'page' => esc_html__('Page', 'aimo' ),
                                'post' => esc_html__('Post', 'aimo' ),
                                'lp_course' => esc_html__('Course', 'aimo' ),
                                'portfolio' => esc_html__('Portfolio', 'aimo' ),
                                'product' => esc_html__('Product', 'aimo' ),
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);