<?php
// Register Image Box Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_image_effect',
        'title' => esc_html__('Case Image Effect', 'aimo' ),
        'icon' => 'eicon-image-box',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'aimo-effects'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'image_effects',
                            'label' => esc_html__('Image Effects', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'options' => [
                                'normal' => [
                                    'title' => esc_html__('Normal', 'aimo' ),
                                    'icon' => 'eicon-exit',
                                ],
                                'expo' => [
                                    'title' => esc_html__('Expo Easing Zoom', 'aimo' ),
                                    'icon' => 'eicon-frame-expand',
                                ],
                                'wave' => [
                                    'title' => esc_html__('Wave', 'aimo' ),
                                    'icon' => 'eicon-slider-3d',
                                ],
                            ],
                            'default' => 'normal',
                        ),
                        array(
                            'name' => 'image_front',
                            'label' => esc_html__( 'Image Front', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'image_back',
                            'label' => esc_html__( 'Image Back', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'image_effects' => 'normal',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'effect_style',
                            'label' => esc_html__('Effect Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style1' => 'Style 1',
                                'style1' => 'Style 1',
                                'style2' => 'Style 2',
                                'style3' => 'Style 3',
                                'style4' => 'Style 4',
                                'style5' => 'Style 5',
                                'style6' => 'Style 6',
                                'style7' => 'Style 7',
                            ],
                            'default' => 'style1',
                        ),
                        array(
                            'name' => 'image_size',
                            'label' => esc_html__('Image Size', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                '100%' => [
                                    'title' => esc_html__('100%', 'aimo' ),
                                    'icon' => 'eicon-text-align-justify',
                                ],
                                'auto' => [
                                    'title' => esc_html__('Auto', 'aimo' ),
                                    'icon' => 'eicon-h-align-stretch',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .item--image img' => 'width: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'img_max_height',
                            'label' => esc_html__('Image Max Height', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%', 'vw', 'vh' ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                                'vw' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                                'vh' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-image-box .item--image img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        
                        array(
                            'name' => 'img_margin',
                            'label' => esc_html__('Image Margin (px)', 'aimo' ),
                            'type' => 'dimensions',
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--inner .item--image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                        ),
                    ),
),
aimo_widget_animation_settings(),
),
),
),
aimo_get_class_widget_path()
);