<?php
if(class_exists('WPCF7')) {
    $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');

    $contact_forms = array();
    if ($cf7) {
        foreach ($cf7 as $cform) {
            $contact_forms[$cform->ID] = $cform->post_title;
        }
    } else {
        $contact_forms[esc_html__('No contact forms found', 'aimo')] = 0;
    }

    pxl_add_custom_widget(
        array(
            'name' => 'pxl_image_split',
            'title' => esc_html__('Case Image Split', 'aimo'),
            'icon' => 'eicon-form-horizontal',
            'categories' => array('pxltheme-core'),
            'params' => array(
                'sections' => array(
                    array(
                        'name' => 'tab_content',
                        'label' => esc_html__('Content', 'aimo'),
                        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                        'controls' => array(
                            array(
                                'name' => 'heading',
                                'label' => esc_html__('Heading', 'aimo'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'h_width',
                                'label' => esc_html__('Max Width', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px', '%' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-image-split .heading' => 'max-width: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'sub_title',
                                'label' => esc_html__('Sub Title', 'aimo'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'lists',
                                'label' => esc_html__('Content', 'aimo'),
                                'type' => \Elementor\Controls_Manager::REPEATER,
                                'controls' => array(
                                    array(
                                        'name' => 'pxl_icon',
                                        'label' => esc_html__('Icon', 'aimo' ),
                                        'type' => \Elementor\Controls_Manager::ICONS,
                                        'fa4compatibility' => 'icon',
                                    ),
                                    array(
                                        'name' => 'text',
                                        'label' => esc_html__('Title', 'aimo'),
                                        'type' => \Elementor\Controls_Manager::TEXT,
                                        'label_block' => true,
                                    ),
                                    array(
                                        'name' => 'desc',
                                        'label' => esc_html__('Desc', 'aimo'),
                                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                                        'label_block' => true,
                                    ),
                                    array(
                                        'name' => 'link',
                                        'label' => esc_html__('Link', 'aimo'),
                                        'type' => \Elementor\Controls_Manager::URL,
                                        'label_block' => true,
                                    ),
                                ),
                                'title_field' => '{{{ text }}}',
                            ),
                            array(
                                'name' => 'button',
                                'label' => esc_html__('Button', 'aimo'),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'link1',
                                'label' => esc_html__('Link Btn', 'aimo'),
                                'type' => \Elementor\Controls_Manager::URL,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'img',
                                'label' => esc_html__('Bg Image', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::MEDIA,
                            ),
                            array(
                                'name' => 'img_size',
                                'label' => esc_html__('Image Size', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                            ),

                        ),
                    ),
                    array(
                        'name' => 'tab_style_input',
                        'label' => esc_html__('Style', 'aimo'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'title_color',
                                'label' => esc_html__('Title Color', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-image-split .heading' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'title_typography',
                                'label' => esc_html__('Title Typography', 'aimo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-image-split .heading',
                            ),
                            array(
                                'name' => 'sub_color',
                                'label' => esc_html__('Text Color', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-image-split .pxl-item--subtext' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'sub_typography',
                                'label' => esc_html__('Title Typography', 'aimo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-image-split .pxl-item--subtext',
                            ),
                            
                        ),
                    ),
                    array(
                        'name' => 'tab_style_list',
                        'label' => esc_html__('List', 'aimo'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'title_color1',
                                'label' => esc_html__('Title Color', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-image-split .pxl-title' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'title_color_hover',
                                'label' => esc_html__('Title Hover', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-image-split .pxl-title:hover ' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'title_typography1',
                                'label' => esc_html__('Title Typography', 'aimo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-image-split .pxl-title',
                            ),
                            array(
                                'name' => 'desc_color',
                                'label' => esc_html__('Desc Color', 'aimo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-image-split .pxl-desc' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'desc_typography',
                                'label' => esc_html__('Desc Typography', 'aimo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-image-split .pxl-desc',
                            ),
                            
                        ),
                    ),
                    aimo_widget_animation_settings(),
                ),
            ),
        ),
        aimo_get_class_widget_path()
    );
}