<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_process',
        'title' => esc_html__('Case Process', 'aimo'),
        'icon' => 'eicon-editor-list-ul',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'aimo' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_process/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_process/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_process/layout3.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content1',
                    'label' => esc_html__('Content', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => '2',
                    ],
                    'controls' => array(
                        array(
                            'name' => 'layout_style',
                            'label' => esc_html__('Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style1' => 'Style White',
                                'style6' => 'Style Dark',
                                
                            ],
                            'default' => 'style1',
                        ),
                        array(
                            'name' => 'img',
                            'label' => esc_html__('Image', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'i_width',
                            'label' => esc_html__('Width', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item-process2 img ' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            
                        ),
                        array(
                            'name' => 'i_height',
                            'label' => esc_html__('Height', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item-process2 img ' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            
                        ),
                        array(
                            'name' => 'list',
                            'label' => esc_html__('Content', 'aimo'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'text1',
                                    'label' => esc_html__('Text', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc1',
                                    'label' => esc_html__('Desc', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'item_position',
                                    'label' => esc_html__('Item Position', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'description' => 'Only selected profiles can be installed (Ex: Top Left)',
                                    'options' => [
                                        'p-center' => 'Center',
                                        'p-top-left' => 'Top Left',
                                        'p-top-right' => 'Top Right',
                                        'p-bottom-left' => 'Bottom Left',
                                        'p-bottom-right' => 'Bottom Right',
                                    ],
                                    'default' => 'p-center',
                                ),
                                array(
                                    'name' => 'item_top_positioon',
                                    'label' => esc_html__('Top Position', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                        'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-top-left, {{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-top-right' => 'top: {{SIZE}}{{UNIT}};',
                                    ],
                                ),
                                array(
                                    'name' => 'item_right_positioon',
                                    'label' => esc_html__('Right Position', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                        'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        ],
                                    ],
                                        'selectors' => [
                                            '{{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-top-right, {{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-bottom-right' => 'right: {{SIZE}}{{UNIT}};',
                                        ],
                                ),
                                array(
                                    'name' => 'item_bottom_positioon',
                                    'label' => esc_html__('Bottom Position', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                        'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-bottom-left, {{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-bottom-right' => 'bottom: {{SIZE}}{{UNIT}};',
                                    ],
                                ),
                                array(
                                    'name' => 'item_left_positioon',
                                    'label' => esc_html__('Left Position', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::SLIDER,
                                    'size_units' => [ 'px', '%' ],
                                    'control_type' => 'responsive',
                                    'range' => [
                                        '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                        'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        ],
                                    ],
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-top-left, {{WRAPPER}} .pxl-item-processs {{CURRENT_ITEM}}.p-bottom-left' => 'left: {{SIZE}}{{UNIT}};',
                                    ],
                                ),
                            ),
                            'title_field' => '{{{ text1 }}}',
                        ),
                    )
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => '1',
                    ],
                    'controls' => array(
                        array(
                            'name' => 'heading',
                            'label' => esc_html__('Heading', 'aimo'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            
                        ),
                        array(
                            'name' => 'sub_title',
                            'label' => esc_html__('Sub Title', 'aimo'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            
                        ),
                        array(
                            'name' => 'align',
                              'label' => esc_html__( 'Alignment', 'aimo' ),
                              'type' => \Elementor\Controls_Manager::CHOOSE,
                              'control_type' => 'responsive',
                              'options' => [
                                  'left' => [
                                      'title' => esc_html__( 'Left', 'aimo' ),
                                      'icon' => 'eicon-text-align-left',
                                  ],
                                  'center' => [
                                      'title' => esc_html__( 'Center', 'aimo' ),
                                      'icon' => 'eicon-text-align-center',
                                  ],
                                  'right' => [
                                      'title' => esc_html__( 'Right', 'aimo' ),
                                      'icon' => 'eicon-text-align-right',
                                  ],
                                  'justify' => [
                                      'title' => esc_html__( 'Justified', 'aimo' ),
                                      'icon' => 'eicon-text-align-justify',
                                  ],
                              ],
                              'selectors' => [
                                  '{{WRAPPER}} .pxl-process .pxl-heading' => 'text-align: {{VALUE}};',
                              ],
                              
                        ),
                        array(
                            'name' => 'h_width',
                            'label' => esc_html__('Max Width Heading', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .heading ' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                            
                        ),
                        
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content', 'aimo'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'text',
                                    'label' => esc_html__('Text', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Desc', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                
                            ),
                            'title_field' => '{{{ text }}}',
                        ),
                        
                        array(
                            'name' => 'button',
                            'label' => esc_html__('Button', 'aimo'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            
                        ),
                        array(
                            'name' => 'link1',
                            'label' => esc_html__('Link Btn', 'aimo'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                            
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Style Heading', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'layout' => '1',
                    ],
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .heading' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'heading_typography',
                            'label' => esc_html__('Heading Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-process .heading',
                        ),
                        array(
                            'name' => 'sub_color',
                            'label' => esc_html__('Title Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .sub-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'sub_typography',
                            'label' => esc_html__('Heading Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-process .sub-title',
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_content_style3',
                    'label' => esc_html__('Content', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => '3',
                    ],
                    'controls' => array(
                       
                        array(
                            'name' => 'lists_layout_3',
                            'label' => esc_html__('Content', 'aimo'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Image', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'img_size_lo21',
                                    'label' => esc_html__('Image Size', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Desc', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'item_link',
                                    'label' => esc_html__('Link', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'box_color',
                                    'label' => esc_html__('Box Color', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::COLOR,
                                    'selectors' => [
                                        '{{WRAPPER}} .pxl-process {{CURRENT_ITEM}}' => 'background: {{VALUE}};',
                                    ],
                                ),
                            ),
                        ),
                        array(
                            'name' => 't_width',
                            'label' => esc_html__('Max Width Desc', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .pxl-item-desc' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'b_width',
                            'label' => esc_html__('Process Width', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'b_height',
                            'label' => esc_html__('Process Height', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_list',
                    'label' => esc_html__('Style List', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Text Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .pxl-item--text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_color_active',
                            'label' => esc_html__('Text Color Active', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .pxl--item.active .pxl-item--text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Text Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-process .pxl-item--text',
                        ),
                        array(
                            'name' => 'name_color',
                            'label' => esc_html__('Desc Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .pxl-item-desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_color_active',
                            'label' => esc_html__('Desc Color Active', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process .pxl--item.active .pxl-item-desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'name_typography',
                            'label' => esc_html__('Name Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-process .pxl-item-desc',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_animate',
                    'label' => esc_html__('Animation', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Animate', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => aimo_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'pxl_animate_delay',
                            'label' => esc_html__('Animate Delay', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                        array(
                            'name' => 'pxl_animate2',
                            'label' => esc_html__('Animate', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => aimo_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'pxl_animate_delay2',
                            'label' => esc_html__('Animate Delay', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                        array(
                            'name' => 'pxl_animate3',
                            'label' => esc_html__('Animate', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => aimo_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'pxl_animate_delay3',
                            'label' => esc_html__('Animate Delay', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                    ),
                ),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);