<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_social_icon',
        'title' => esc_html__('Case Social Icons', 'aimo'),
        'icon' => 'eicon-social-icons',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'icons',
                            'label' => esc_html__('Social Icons', 'aimo'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'recommended' => [
                                    'fa-brands' => [
                                        'android',
                                        'apple',
                                        'behance',
                                        'bitbucket',
                                        'codepen',
                                        'delicious',
                                        'deviantart',
                                        'digg',
                                        'dribbble',
                                        'elementor',
                                        'facebook',
                                        'flickr',
                                        'foursquare',
                                        'free-code-camp',
                                        'github',
                                        'gitlab',
                                        'globe',
                                        'houzz',
                                        'instagram',
                                        'jsfiddle',
                                        'linkedin',
                                        'medium',
                                        'meetup',
                                        'mix',
                                        'mixcloud',
                                        'odnoklassniki',
                                        'pinterest',
                                        'product-hunt',
                                        'reddit',
                                        'shopping-cart',
                                        'skype',
                                        'slideshare',
                                        'snapchat',
                                        'soundcloud',
                                        'spotify',
                                        'stack-overflow',
                                        'steam',
                                        'telegram',
                                        'thumb-tack',
                                        'tripadvisor',
                                        'tumblr',
                                        'twitch',
                                        'twitter',
                                        'viber',
                                        'vimeo',
                                        'vk',
                                        'weibo',
                                        'weixin',
                                        'whatsapp',
                                        'wordpress',
                                        'xing',
                                        'yelp',
                                        'youtube',
                                        '500px',
                                    ],
                                    'fa-solid' => [
                                        'envelope',
                                        'link',
                                        'rss',
                                    ],
                                ],
                                ),
                                array(
                                    'name' => 'icon_link',
                                    'label' => esc_html__('Link', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ label }}}',
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'margin',
                            'label' => esc_html__('Margin', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-social-icons a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-social-icons' => 'margin-left: -{{LEFT}}{{UNIT}};margin-right: -{{RIGHT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                    ),
                ),
                aimo_widget_animation_settings(),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);