<?php
$slides_to_show = range( 1, 10 );
$slides_to_show = array_combine( $slides_to_show, $slides_to_show );

pxl_add_custom_widget(
    array(
        'name' => 'pxl_testimonial_carousel',
        'title' => esc_html__('Case Testimonial Carousel', 'aimo'),
        'icon' => 'eicon-testimonial',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'aimo' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'aimo' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_testimonial_carousel/layout4.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'testimonial',
                            'label' => esc_html__('Testimonial', 'aimo'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'position1',
                                    'label' => esc_html__('Position1', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    
                                ),
                                array(
                                    'name' => 'position2',
                                    'label' => esc_html__('Position2', 'aimo'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Description', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Avatar', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::URL,
                                ),
                                array(
                                    'name' => 'style_star',
                                    'label' => esc_html__('Choose Star', 'aimo' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        '1-star'   => '1 Star',
                                        '2-star'   => '2 Star',
                                        '3-star'   => '3 Star',
                                        '4-star'   => '4 Star',
                                        '5-star'   => '5 Star',
                                    ],
                                    'default' => '5-star',
                                )
                                
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'style_l1',
                            'label' => esc_html__('Style', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-1',
                            'options' => [
                                'style-1' => 'Hide Star',
                                'style-2' => 'Show Star',
                            ],
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link Button', 'aimo'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                            'condition' => [
                                'layout!' => ['3'],
                            ],
                        ),
                        array(
                            'name' => 'image1',
                            'label' => esc_html__('Image', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'layout' => ['3'],
                            ],
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size1', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => ['3'],
                            ],
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        array(
                            'name' => 'title_',
                            'label' => esc_html__('Title', 'aimo'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'layout' => ['3'],
                            ],
                        ),
                        array(
                            'name' => 'position_',
                            'label' => esc_html__('Position', 'aimo'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'layout' => ['3'],
                            ],
                        ),
                    ),
                ),
               
                array(
                    'name' => 'section_style_general',
                    'label' => esc_html__('General', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'bg_color',
                            'label' => esc_html__('Bg Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => '2',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel2 .pxl-item--inner::before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'tt1_color',
                            'label' => esc_html__('Name Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => '3',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-content .pxl-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'tt1_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'condition' => [
                                'layout' => '3',
                            ],
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-content .pxl-title',
                        ),
                        array(
                            'name' => 'desc1_color',
                            'label' => esc_html__('Desc Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => '3',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-content .pxl-desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc1_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'condition' => [
                                'layout' => '3',
                            ],
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-content .pxl-desc',
                        ),
                        array(
                            'name' => 'tt2_color',
                            'label' => esc_html__('Name Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => '4',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel4 .pxl-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'tt2_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'condition' => [
                                'layout' => '4',
                            ],
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel4 .pxl-title',
                        ),
                        array(
                            'name' => 'desc2_color',
                            'label' => esc_html__('Desc Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => '4',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel4 .pxl-position' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc2_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'condition' => [
                                'layout' => '4',
                            ],
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel4 .pxl-position',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--title:not(.wg_title)',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_position1',
                    'label' => esc_html__('Style Out Content', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'layout' => ['3'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'tt_color',
                            'label' => esc_html__('Title Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-title' => 'color: {{VALUE}};',
                            ],
                            
                        ),
                        array(
                            'name' => 'tt_typography',
                            'label' => esc_html__('Title Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-title',
                        ),
                        array(
                            'name' => 'position_color1',
                            'label' => esc_html__('Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-desc' => 'color: {{VALUE}};',
                            ],
                            
                        ),
                        array(
                            'name' => 'position_typography1',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel3 .pxl-desc',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_position',
                    'label' => esc_html__('Position', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'layout' => ['1'],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'position_color',
                            'label' => esc_html__('Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--position' => 'color: {{VALUE}};',
                            ],
                            
                        ),
                        array(
                            'name' => 'position_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--position',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_desc',
                    'label' => esc_html__('Description', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__('Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_typography',
                            'label' => esc_html__('Typography', 'aimo' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--desc',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_star',
                    'label' => esc_html__('Rating', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'rating_color',
                            'label' => esc_html__( 'Color', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--star' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Font Size', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-item--star' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    )
                ),
                array(
                    'name' => 'section_swiper',
                    'label' => esc_html__('Swiper', 'aimo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'bullet_color',
                            'label' => esc_html__( 'Bullet', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-swiper-dots.style-1 span' => 'background: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bullet_color1',
                            'label' => esc_html__( 'Bullet', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'condition' => [
                                'layout' => '4',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel.pxl-testimonial-carousel4 .pxl-swiper-dots .pxl-swiper-pagination-bullet > span' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'bullet_color_active',
                            'label' => esc_html__( 'Bullet Active', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-swiper-dots .pxl-swiper-pagination-bullet.swiper-pagination-bullet-active span' => 'background: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'arrow_color',
                            'label' => esc_html__( 'Arrow', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-swiper-arrow-wrap .pxl-swiper-arrow' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'arrow_color_hover',
                            'label' => esc_html__( 'Arrow Hover', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-testimonial-carousel .pxl-swiper-arrow-wrap .pxl-swiper-arrow:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'feature_active',
                            'label' => esc_html__('Color Dark Mode', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'condition' => [
                                'layout' => '3',
                            ],
                            'options' => [
                                'pxl-dark-mode' => 'Yes',
                                'no' => 'No',
                            ],
                            'default' => 'no',
                        ),
                    )
                ),
                array(
                    'name' => 'section_settings_carousel',
                    'label' => esc_html__('Settings', 'aimo'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                'auto' => 'Auto',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'aimo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                                'progressbar' => 'Progressbar',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),

                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Delay', 'aimo'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'aimo'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'aimo'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => false,
                        ),
                    ),
                ),
                aimo_widget_animation_settings(),
            ),
        ),
    ),
    aimo_get_class_widget_path()
);