<?php

if (!class_exists('Aimo_Blog')) {

    class Aimo_Blog
    {
        
        public function get_archive_meta() {
            $archive_author = aimo()->get_theme_opt( 'archive_author', true );
            $archive_date = aimo()->get_theme_opt( 'archive_date', true );
            $archive_comment = aimo()->get_theme_opt( 'archive_comment', true );
            if($archive_author || $archive_category || $archive_date || $archive_comment) : ?>
                <div class="pxl-item--meta pxl-blog-meta">
                <div class="pxl-blog-meta-inner">
                        <?php if($archive_author) : ?>
                            <div class="pxl-item--author pxl-mr-30">
                                <div class="pxl-svg1 pxl-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="#A234FD">
                                        <path d="M15.364 2.63605C13.6641 0.936176 11.404 0 9 0C6.59602 0 4.33593 0.936176 2.63602 2.63605C0.936176 4.33593 0 6.59602 0 9C0 11.404 0.936176 13.6641 2.63602 15.3639C4.33593 17.0638 6.59602 18 9 18C11.404 18 13.6641 17.0638 15.364 15.3639C17.0638 13.6641 18 11.404 18 9C18 6.59602 17.0638 4.33593 15.364 2.63605ZM9 16.9453C6.64914 16.9453 4.53386 15.9187 3.07786 14.2906C3.9805 11.8976 6.29114 10.1953 9 10.1953C7.25252 10.1953 5.83594 8.77873 5.83594 7.03125C5.83594 5.28377 7.25252 3.86719 9 3.86719C10.7475 3.86719 12.1641 5.28377 12.1641 7.03125C12.1641 8.77873 10.7475 10.1953 9 10.1953C11.7089 10.1953 14.0195 11.8976 14.9221 14.2906C13.4661 15.9187 11.3509 16.9453 9 16.9453Z" />
                                    </svg>
                                </div>
                                <?php the_author_posts_link(); ?>
                            </div>
                        <?php endif; ?>
                        <?php if($archive_comment) : ?>
                            <div class="pxl-item--comment pxl-mr-30">
                                <div class="pxl-svg2 pxl-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="#A234FD">
                                        <g clip-path="url(#clip0_74_1428)">
                                            <path d="M4.39997 4.28083H4.65749C5.04885 4.28083 5.36609 3.96348 5.36609 3.57223V1.61679V0.885355C5.36609 0.494103 5.04885 0.176788 4.65749 0.176788H4.39997C4.00865 0.176788 3.69141 0.494103 3.69141 0.885355V1.61682V3.57223C3.69141 3.96348 4.00865 4.28083 4.39997 4.28083Z" />
                                            <path d="M13.486 4.26325H13.7435C14.1348 4.26325 14.4521 3.94594 14.4521 3.55465V1.43118V0.86774C14.4521 0.476525 14.1348 0.15921 13.7435 0.15921H13.486C13.0946 0.15921 12.7773 0.476525 12.7773 0.86774V1.43118V3.55461C12.7774 3.94594 13.0947 4.26325 13.486 4.26325Z" />
                                            <path d="M16.8481 1.61676H15.0295V3.7402C15.0295 4.44854 14.4532 4.83923 13.745 4.83923H13.4874C12.7791 4.83923 12.2029 4.26295 12.2029 3.55461V1.61676H5.94071V3.57217C5.94071 4.28051 5.36447 4.85679 4.65612 4.85679H4.39861C3.6903 4.85679 3.11405 4.28051 3.11405 3.57217V1.61676H1.15197C0.516782 1.61676 0 2.13354 0 2.76877V16.6888C0 17.324 0.516782 17.8408 1.15197 17.8408H16.8481C17.4833 17.8408 18 17.324 18 16.6888V2.76877C18.0001 2.13358 17.4833 1.61676 16.8481 1.61676ZM16.8481 16.6888H1.15201L1.15197 6.17675H16.8483L16.8489 16.6888C16.8488 16.6888 16.8486 16.6888 16.8481 16.6888Z" />
                                            <path d="M9.59378 9.7028H11.6622C11.7442 9.7028 11.8107 9.63633 11.8107 9.55433V7.76325C11.8107 7.68125 11.7442 7.61478 11.6622 7.61478H9.59378C9.51179 7.61478 9.44531 7.68125 9.44531 7.76325V9.55433C9.44531 9.63633 9.51179 9.7028 9.59378 9.7028Z" />
                                            <path d="M12.9688 9.7028H15.0372C15.1192 9.7028 15.1857 9.63633 15.1857 9.55433V7.76325C15.1857 7.68125 15.1192 7.61478 15.0372 7.61478H12.9688C12.8868 7.61478 12.8203 7.68125 12.8203 7.76325V9.55433C12.8203 9.63633 12.8868 9.7028 12.9688 9.7028Z" />
                                            <path d="M2.84378 12.6351H4.91217C4.99416 12.6351 5.06064 12.5686 5.06064 12.4866V10.6955C5.06064 10.6135 4.99416 10.547 4.91217 10.547H2.84378C2.76179 10.547 2.69531 10.6135 2.69531 10.6955V12.4866C2.69531 12.5686 2.76179 12.6351 2.84378 12.6351Z" />
                                            <path d="M6.21878 12.635H8.28717C8.36916 12.635 8.43564 12.5685 8.43564 12.4865V10.6954C8.43564 10.6134 8.36916 10.5469 8.28717 10.5469H6.21878C6.13679 10.5469 6.07031 10.6134 6.07031 10.6954V12.4865C6.07031 12.5685 6.13679 12.635 6.21878 12.635Z" />
                                            <path d="M9.59378 12.635H11.6622C11.7442 12.635 11.8106 12.5685 11.8106 12.4865V10.6954C11.8106 10.6134 11.7442 10.5469 11.6622 10.5469H9.59378C9.51179 10.5469 9.44531 10.6134 9.44531 10.6954V12.4865C9.44531 12.5685 9.51179 12.635 9.59378 12.635Z" />
                                            <path d="M12.9688 12.635H15.0372C15.1192 12.635 15.1857 12.5685 15.1857 12.4865V10.6954C15.1857 10.6134 15.1192 10.5469 15.0372 10.5469H12.9688C12.8868 10.5469 12.8203 10.6134 12.8203 10.6954V12.4865C12.8203 12.5685 12.8868 12.635 12.9688 12.635Z" />
                                            <path d="M4.91213 13.4792H2.84378C2.76179 13.4792 2.69531 13.5457 2.69531 13.6277V15.4188C2.69531 15.5008 2.76179 15.5673 2.84378 15.5673H4.91217C4.99416 15.5673 5.06064 15.5008 5.06064 15.4188V13.6277C5.0606 13.5457 4.99413 13.4792 4.91213 13.4792Z" />
                                            <path d="M8.28717 13.4793H6.21878C6.13679 13.4793 6.07031 13.5458 6.07031 13.6277V15.4189C6.07031 15.5009 6.13679 15.5673 6.21878 15.5673H8.28717C8.36916 15.5673 8.43564 15.5009 8.43564 15.4189V13.6277C8.43564 13.5458 8.36916 13.4793 8.28717 13.4793Z" />
                                            <path d="M11.6622 13.4793H9.59378C9.51179 13.4793 9.44531 13.5458 9.44531 13.6277V15.4189C9.44531 15.5009 9.51179 15.5673 9.59378 15.5673H11.6622C11.7442 15.5673 11.8107 15.5009 11.8107 15.4189V13.6277C11.8107 13.5458 11.7442 13.4793 11.6622 13.4793Z" />
                                            <path d="M15.0372 13.4793H12.9688C12.8868 13.4793 12.8203 13.5458 12.8203 13.6277V15.4189C12.8203 15.5009 12.8868 15.5673 12.9688 15.5673H15.0372C15.1192 15.5673 15.1857 15.5009 15.1857 15.4189V13.6277C15.1857 13.5458 15.1192 13.4793 15.0372 13.4793Z" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_74_1428">
                                            <rect width="18" height="18" fill="white"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <a href="<?php the_permalink(); ?>#comments">
                                    <?php echo comments_number(esc_html__('Comments (0)', 'aimo'),esc_html__('Comment (1)', 'aimo'),esc_html__('Comments (%)', 'aimo')); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if($archive_date) : ?>
                            <div class="pxl-item--date pxl-mr-30">
                                <div class="pxl-svg3 pxl-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="#A234FD">
                                        <g clip-path="url(#clip0_74_1447)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M4.92161 11.1441C4.92185 11.1652 4.93036 11.1855 4.94534 11.2005C4.96031 11.2154 4.98056 11.224 5.00173 11.2242H16.2498C16.2709 11.2239 16.2911 11.2153 16.306 11.2003C16.3208 11.1854 16.3293 11.1652 16.3295 11.1441V1.23296L13.8984 2.93699C13.66 3.10785 13.3733 3.19836 13.0799 3.19542H5.00173C4.98053 3.19566 4.96027 3.2042 4.94529 3.2192C4.93031 3.23421 4.92181 3.25448 4.92161 3.27568V11.1441ZM0.824219 17.5781V6.8561C0.82447 6.61109 0.921921 6.37619 1.09518 6.20295C1.26844 6.02972 1.50336 5.9323 1.74837 5.93209H4.07789V3.27568C4.07815 3.03071 4.17555 2.79585 4.34874 2.6226C4.52193 2.44935 4.75676 2.35187 5.00173 2.35153H13.0799C13.1999 2.35423 13.3173 2.31714 13.4139 2.24606L16.5086 0.0764296C16.5718 0.0320227 16.6461 0.00582504 16.7232 0.000689442C16.8003 -0.00444615 16.8774 0.0116773 16.946 0.0473038C17.0146 0.0829303 17.0721 0.136694 17.1122 0.20274C17.1524 0.268786 17.1736 0.344583 17.1737 0.421875V11.1441C17.1734 11.389 17.076 11.6238 16.9028 11.797C16.7296 11.9702 16.4948 12.0676 16.2498 12.0679H13.9199V14.7245C13.9195 14.9695 13.822 15.2044 13.6487 15.3776C13.4754 15.5508 13.2405 15.6482 12.9955 15.6485H4.91764C4.79763 15.6457 4.68009 15.6828 4.58344 15.754L1.48814 17.9236C1.42493 17.9679 1.35078 17.994 1.27376 17.999C1.19675 18.0041 1.11982 17.9879 1.05135 17.9523C0.982888 17.9167 0.925507 17.863 0.885458 17.797C0.845409 17.731 0.824228 17.6553 0.824219 17.5781ZM6.23424 8.40523C6.23424 8.29334 6.27869 8.18603 6.3578 8.10692C6.43692 8.0278 6.54423 7.98335 6.65611 7.98335H14.5949C14.7068 7.98335 14.8141 8.0278 14.8932 8.10692C14.9723 8.18603 15.0168 8.29334 15.0168 8.40523C15.0168 8.51711 14.9723 8.62442 14.8932 8.70354C14.8141 8.78265 14.7068 8.8271 14.5949 8.8271H6.65618C6.5443 8.8271 6.43699 8.78265 6.35787 8.70354C6.27876 8.62442 6.23431 8.51711 6.23431 8.40523H6.23424ZM6.23424 6.01436C6.23424 5.90247 6.27869 5.79516 6.3578 5.71604C6.43692 5.63693 6.54423 5.59248 6.65611 5.59248H12.4231C12.535 5.59248 12.6423 5.63693 12.7214 5.71604C12.8005 5.79516 12.845 5.90247 12.845 6.01436C12.845 6.12624 12.8005 6.23355 12.7214 6.31267C12.6423 6.39178 12.535 6.43623 12.4231 6.43623H6.65618C6.60078 6.43624 6.54591 6.42533 6.49472 6.40414C6.44353 6.38294 6.39701 6.35187 6.35783 6.31269C6.31865 6.27352 6.28756 6.22701 6.26636 6.17582C6.24515 6.12463 6.23424 6.06976 6.23424 6.01436Z" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_74_1447">
                                            <rect width="18" height="18" fill="white"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <?php echo get_the_date('F j, Y'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_post_metas(){
            $post_author = aimo()->get_theme_opt( 'post_author', true );
            $post_comment = aimo()->get_theme_opt( 'post_comment', true );
            $post_date = aimo()->get_theme_opt( 'post_date', true );
            if($post_author || $post_date) : ?>
                <div class="pxl-item--meta pxl-blog-meta">
                    <div class="pxl-blog-meta-inner">
                        <?php if($post_author) : ?>
                            <div class="pxl-item--author pxl-mr-30">
                                <div class="pxl-svg1 pxl-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="#A234FD">
                                        <path d="M15.364 2.63605C13.6641 0.936176 11.404 0 9 0C6.59602 0 4.33593 0.936176 2.63602 2.63605C0.936176 4.33593 0 6.59602 0 9C0 11.404 0.936176 13.6641 2.63602 15.3639C4.33593 17.0638 6.59602 18 9 18C11.404 18 13.6641 17.0638 15.364 15.3639C17.0638 13.6641 18 11.404 18 9C18 6.59602 17.0638 4.33593 15.364 2.63605ZM9 16.9453C6.64914 16.9453 4.53386 15.9187 3.07786 14.2906C3.9805 11.8976 6.29114 10.1953 9 10.1953C7.25252 10.1953 5.83594 8.77873 5.83594 7.03125C5.83594 5.28377 7.25252 3.86719 9 3.86719C10.7475 3.86719 12.1641 5.28377 12.1641 7.03125C12.1641 8.77873 10.7475 10.1953 9 10.1953C11.7089 10.1953 14.0195 11.8976 14.9221 14.2906C13.4661 15.9187 11.3509 16.9453 9 16.9453Z" />
                                    </svg>
                                </div>
                                <?php the_author_posts_link(); ?>
                            </div>
                        <?php endif; ?>
                        <?php if($post_comment) : ?>
                            <div class="pxl-item--comment pxl-mr-30">
                                <div class="pxl-svg2 pxl-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="#A234FD">
                                        <g clip-path="url(#clip0_74_1428)">
                                            <path d="M4.39997 4.28083H4.65749C5.04885 4.28083 5.36609 3.96348 5.36609 3.57223V1.61679V0.885355C5.36609 0.494103 5.04885 0.176788 4.65749 0.176788H4.39997C4.00865 0.176788 3.69141 0.494103 3.69141 0.885355V1.61682V3.57223C3.69141 3.96348 4.00865 4.28083 4.39997 4.28083Z" />
                                            <path d="M13.486 4.26325H13.7435C14.1348 4.26325 14.4521 3.94594 14.4521 3.55465V1.43118V0.86774C14.4521 0.476525 14.1348 0.15921 13.7435 0.15921H13.486C13.0946 0.15921 12.7773 0.476525 12.7773 0.86774V1.43118V3.55461C12.7774 3.94594 13.0947 4.26325 13.486 4.26325Z" />
                                            <path d="M16.8481 1.61676H15.0295V3.7402C15.0295 4.44854 14.4532 4.83923 13.745 4.83923H13.4874C12.7791 4.83923 12.2029 4.26295 12.2029 3.55461V1.61676H5.94071V3.57217C5.94071 4.28051 5.36447 4.85679 4.65612 4.85679H4.39861C3.6903 4.85679 3.11405 4.28051 3.11405 3.57217V1.61676H1.15197C0.516782 1.61676 0 2.13354 0 2.76877V16.6888C0 17.324 0.516782 17.8408 1.15197 17.8408H16.8481C17.4833 17.8408 18 17.324 18 16.6888V2.76877C18.0001 2.13358 17.4833 1.61676 16.8481 1.61676ZM16.8481 16.6888H1.15201L1.15197 6.17675H16.8483L16.8489 16.6888C16.8488 16.6888 16.8486 16.6888 16.8481 16.6888Z" />
                                            <path d="M9.59378 9.7028H11.6622C11.7442 9.7028 11.8107 9.63633 11.8107 9.55433V7.76325C11.8107 7.68125 11.7442 7.61478 11.6622 7.61478H9.59378C9.51179 7.61478 9.44531 7.68125 9.44531 7.76325V9.55433C9.44531 9.63633 9.51179 9.7028 9.59378 9.7028Z" />
                                            <path d="M12.9688 9.7028H15.0372C15.1192 9.7028 15.1857 9.63633 15.1857 9.55433V7.76325C15.1857 7.68125 15.1192 7.61478 15.0372 7.61478H12.9688C12.8868 7.61478 12.8203 7.68125 12.8203 7.76325V9.55433C12.8203 9.63633 12.8868 9.7028 12.9688 9.7028Z" />
                                            <path d="M2.84378 12.6351H4.91217C4.99416 12.6351 5.06064 12.5686 5.06064 12.4866V10.6955C5.06064 10.6135 4.99416 10.547 4.91217 10.547H2.84378C2.76179 10.547 2.69531 10.6135 2.69531 10.6955V12.4866C2.69531 12.5686 2.76179 12.6351 2.84378 12.6351Z" />
                                            <path d="M6.21878 12.635H8.28717C8.36916 12.635 8.43564 12.5685 8.43564 12.4865V10.6954C8.43564 10.6134 8.36916 10.5469 8.28717 10.5469H6.21878C6.13679 10.5469 6.07031 10.6134 6.07031 10.6954V12.4865C6.07031 12.5685 6.13679 12.635 6.21878 12.635Z" />
                                            <path d="M9.59378 12.635H11.6622C11.7442 12.635 11.8106 12.5685 11.8106 12.4865V10.6954C11.8106 10.6134 11.7442 10.5469 11.6622 10.5469H9.59378C9.51179 10.5469 9.44531 10.6134 9.44531 10.6954V12.4865C9.44531 12.5685 9.51179 12.635 9.59378 12.635Z" />
                                            <path d="M12.9688 12.635H15.0372C15.1192 12.635 15.1857 12.5685 15.1857 12.4865V10.6954C15.1857 10.6134 15.1192 10.5469 15.0372 10.5469H12.9688C12.8868 10.5469 12.8203 10.6134 12.8203 10.6954V12.4865C12.8203 12.5685 12.8868 12.635 12.9688 12.635Z" />
                                            <path d="M4.91213 13.4792H2.84378C2.76179 13.4792 2.69531 13.5457 2.69531 13.6277V15.4188C2.69531 15.5008 2.76179 15.5673 2.84378 15.5673H4.91217C4.99416 15.5673 5.06064 15.5008 5.06064 15.4188V13.6277C5.0606 13.5457 4.99413 13.4792 4.91213 13.4792Z" />
                                            <path d="M8.28717 13.4793H6.21878C6.13679 13.4793 6.07031 13.5458 6.07031 13.6277V15.4189C6.07031 15.5009 6.13679 15.5673 6.21878 15.5673H8.28717C8.36916 15.5673 8.43564 15.5009 8.43564 15.4189V13.6277C8.43564 13.5458 8.36916 13.4793 8.28717 13.4793Z" />
                                            <path d="M11.6622 13.4793H9.59378C9.51179 13.4793 9.44531 13.5458 9.44531 13.6277V15.4189C9.44531 15.5009 9.51179 15.5673 9.59378 15.5673H11.6622C11.7442 15.5673 11.8107 15.5009 11.8107 15.4189V13.6277C11.8107 13.5458 11.7442 13.4793 11.6622 13.4793Z" />
                                            <path d="M15.0372 13.4793H12.9688C12.8868 13.4793 12.8203 13.5458 12.8203 13.6277V15.4189C12.8203 15.5009 12.8868 15.5673 12.9688 15.5673H15.0372C15.1192 15.5673 15.1857 15.5009 15.1857 15.4189V13.6277C15.1857 13.5458 15.1192 13.4793 15.0372 13.4793Z" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_74_1428">
                                            <rect width="18" height="18" fill="white"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <a href="<?php the_permalink(); ?>#comments">
                                    <?php echo comments_number(esc_html__('Comments (0)', 'aimo'),esc_html__('Comment (1)', 'aimo'),esc_html__('Comments (%)', 'aimo')); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if($post_date) : ?>
                            <div class="pxl-item--date pxl-mr-30">
                                <div class="pxl-svg3 pxl-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="#A234FD">
                                        <g clip-path="url(#clip0_74_1447)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M4.92161 11.1441C4.92185 11.1652 4.93036 11.1855 4.94534 11.2005C4.96031 11.2154 4.98056 11.224 5.00173 11.2242H16.2498C16.2709 11.2239 16.2911 11.2153 16.306 11.2003C16.3208 11.1854 16.3293 11.1652 16.3295 11.1441V1.23296L13.8984 2.93699C13.66 3.10785 13.3733 3.19836 13.0799 3.19542H5.00173C4.98053 3.19566 4.96027 3.2042 4.94529 3.2192C4.93031 3.23421 4.92181 3.25448 4.92161 3.27568V11.1441ZM0.824219 17.5781V6.8561C0.82447 6.61109 0.921921 6.37619 1.09518 6.20295C1.26844 6.02972 1.50336 5.9323 1.74837 5.93209H4.07789V3.27568C4.07815 3.03071 4.17555 2.79585 4.34874 2.6226C4.52193 2.44935 4.75676 2.35187 5.00173 2.35153H13.0799C13.1999 2.35423 13.3173 2.31714 13.4139 2.24606L16.5086 0.0764296C16.5718 0.0320227 16.6461 0.00582504 16.7232 0.000689442C16.8003 -0.00444615 16.8774 0.0116773 16.946 0.0473038C17.0146 0.0829303 17.0721 0.136694 17.1122 0.20274C17.1524 0.268786 17.1736 0.344583 17.1737 0.421875V11.1441C17.1734 11.389 17.076 11.6238 16.9028 11.797C16.7296 11.9702 16.4948 12.0676 16.2498 12.0679H13.9199V14.7245C13.9195 14.9695 13.822 15.2044 13.6487 15.3776C13.4754 15.5508 13.2405 15.6482 12.9955 15.6485H4.91764C4.79763 15.6457 4.68009 15.6828 4.58344 15.754L1.48814 17.9236C1.42493 17.9679 1.35078 17.994 1.27376 17.999C1.19675 18.0041 1.11982 17.9879 1.05135 17.9523C0.982888 17.9167 0.925507 17.863 0.885458 17.797C0.845409 17.731 0.824228 17.6553 0.824219 17.5781ZM6.23424 8.40523C6.23424 8.29334 6.27869 8.18603 6.3578 8.10692C6.43692 8.0278 6.54423 7.98335 6.65611 7.98335H14.5949C14.7068 7.98335 14.8141 8.0278 14.8932 8.10692C14.9723 8.18603 15.0168 8.29334 15.0168 8.40523C15.0168 8.51711 14.9723 8.62442 14.8932 8.70354C14.8141 8.78265 14.7068 8.8271 14.5949 8.8271H6.65618C6.5443 8.8271 6.43699 8.78265 6.35787 8.70354C6.27876 8.62442 6.23431 8.51711 6.23431 8.40523H6.23424ZM6.23424 6.01436C6.23424 5.90247 6.27869 5.79516 6.3578 5.71604C6.43692 5.63693 6.54423 5.59248 6.65611 5.59248H12.4231C12.535 5.59248 12.6423 5.63693 12.7214 5.71604C12.8005 5.79516 12.845 5.90247 12.845 6.01436C12.845 6.12624 12.8005 6.23355 12.7214 6.31267C12.6423 6.39178 12.535 6.43623 12.4231 6.43623H6.65618C6.60078 6.43624 6.54591 6.42533 6.49472 6.40414C6.44353 6.38294 6.39701 6.35187 6.35783 6.31269C6.31865 6.27352 6.28756 6.22701 6.26636 6.17582C6.24515 6.12463 6.23424 6.06976 6.23424 6.01436Z" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_74_1447">
                                            <rect width="18" height="18" fill="white"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <?php echo get_the_date('F j, Y'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_excerpt(){
            $archive_excerpt_length = aimo()->get_theme_opt('archive_excerpt_length', '50');
            $aimo_the_excerpt = get_the_excerpt();
            if(!empty($aimo_the_excerpt)) {
                echo wp_trim_words( $aimo_the_excerpt, $archive_excerpt_length, $more = null );
            } else {
                echo wp_kses_post($this->get_excerpt_more( $archive_excerpt_length ));
            }
        }

        public function get_excerpt_more( $post = null ) {
            $archive_excerpt_length = aimo()->get_theme_opt('archive_excerpt_length', '50');
            $post = get_post( $post );

            if ( empty( $post ) || 0 >= $archive_excerpt_length ) {
                return '';
            }

            if ( post_password_required( $post ) ) {
                return esc_html__( 'Post password required.', 'aimo' );
            }

            $content = apply_filters( 'the_content', strip_shortcodes( $post->post_content ) );
            $content = str_replace( ']]>', ']]&gt;', $content );

            $excerpt_more = apply_filters( 'aimo_excerpt_more', '&hellip;' );
            $excerpt      = wp_trim_words( $content, $archive_excerpt_length, $excerpt_more );

            return $excerpt;
        }

        public function aimo_set_post_views( $postID ) {
            $countKey = 'post_views_count';
            $count    = get_post_meta( $postID, $countKey, true );
            if ( $count == '' ) {
                $count = 0;
                delete_post_meta( $postID, $countKey );
                add_post_meta( $postID, $countKey, '0' );
            } else {
                $count ++;
                update_post_meta( $postID, $countKey, $count );
            }
        }

        public function get_tagged_in(){
            $tags_list = get_the_tag_list( '<label class="label">'.esc_attr__('Tag:', 'aimo'). '</label>', ' ' );
            if ( $tags_list )
            {
                echo '<div class="pxl--tags">';
                printf('%2$s', '', $tags_list);
                echo '</div>';
            }
        }

        public function get_socials_share() { 
            $img_url = '';
            if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
            }
            $social_facebook = aimo()->get_theme_opt( 'social_facebook', true );
            $social_twitter = aimo()->get_theme_opt( 'social_twitter', true );
            $social_pinterest = aimo()->get_theme_opt( 'social_pinterest', true );
            $social_linkedin = aimo()->get_theme_opt( 'social_linkedin', true );
            $copy_link = aimo()->get_theme_opt( 'copy_link', true );
            ?>
            <div class="pxl--social">
                <label><?php echo esc_html__('Share on Social:', 'aimo'); ?></label>
                <div class="pxl-socials">
                <?php if($social_facebook) : ?>
                    <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'aimo'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
                <?php endif; ?>
                <?php if($social_twitter) : ?>
                    <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'aimo'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="caseicon-twitter"></i></a>
                <?php endif; ?>
                <?php if($social_pinterest) : ?>
                    <a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'aimo'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="caseicon-pinterest"></i></a>
                <?php endif; ?>
                <?php if($social_linkedin) : ?>
                    <a class="lin-social" title="<?php echo esc_attr__('LinkedIn', 'aimo'); ?>" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>%20"><i class="caseicon-linkedin"></i></a>
                <?php endif; ?>
                <?php if($copy_link) : ?>
                    <a class="btn-copy-link" title="<?php echo esc_attr__('Copy Link', 'aimo'); ?>" href="#"><i aria-hidden="true" class="flaticon flaticon-link"></i></a>
                <?php endif; ?>
                </div>
            </div>
            <?php
        }

        public function get_socials_share_portfolio() { 
            $img_url = '';
            if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
            }
            ?>
            <div class="pxl--social">
                <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'aimo'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
                <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'aimo'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="caseicon-twitter"></i></a>
                <a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'aimo'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="caseicon-pinterest"></i></a>
                <a class="lin-social" title="<?php echo esc_attr__('LinkedIn', 'aimo'); ?>" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>%20"><i class="caseicon-linkedin"></i></a>
            </div>
            <?php
        }

        public function get_post_nav() {
            global $post;
            $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
            $next     = get_adjacent_post( false, '', false );

            if ( ! $next && ! $previous )
                return;
            ?>
            <?php
            $next_post = get_next_post();
            $previous_post = get_previous_post();

            if( !empty($next_post) || !empty($previous_post) ) { 
                $page_for_posts = get_option( 'page_for_posts' );
                ?>
                <div class="pxl-post--navigation pxl-flex">
                    
                    <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { 
                        $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                        $img_prev  = pxl_get_image_by_size( array(
                            'attach_id'  => $prev_img_id,
                            'thumb_size' => '260x260',
                        ) );
                        $thumbnail_prev    = $img_prev['url']; ?>
                        <div class="pxl-navigation--col pxl-navigation--prev">
                            <div class="pxl-navigation--image bg-image pxl-mr-15" style="background-image: url(<?php echo esc_url($thumbnail_prev); ?>);">
                                <div class="pxl-navigation--icon"><i class="flaticon-left-arrow"></i></div>
                                <a href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>" class="pxl-navigation--link"></a>
                            </div>
                            <div class="pxl-navigation--meta">
                                <div class="pxl-navigation--date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $previous_post->ID); ?></div>
                                <h5 class="pxl-navigation--title">
                                    <a  href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><?php echo get_the_title( $previous_post->ID ); ?></a>
                                </h5>
                            </div>
                        </div>
                    <?php } ?>
                    
                    <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') { 
                        $next_img_id = get_post_thumbnail_id($next_post->ID);
                        $img_next  = pxl_get_image_by_size( array(
                            'attach_id'  => $next_img_id,
                            'thumb_size' => '260x260',
                        ) );
                        $thumbnail_next    = $img_next['url']; ?>
                        <div class="pxl-navigation--col pxl-navigation--next">
                            <div class="pxl-navigation--meta pxl-text-right">
                                <div class="pxl-navigation--date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $next_post->ID); ?></div>
                                <h5 class="pxl-navigation--title">
                                    <a  href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><?php echo get_the_title( $next_post->ID ); ?></a>
                                </h5>
                            </div>
                            <div class="pxl-navigation--image bg-image pxl-ml-15" style="background-image: url(<?php echo esc_url($thumbnail_next); ?>);">
                                <div class="pxl-navigation--icon"><i class="flaticon-right-arrow-6"></i></div>
                                <a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>" class="pxl-navigation--link"></a>
                            </div>
                        </div>
                    <?php } ?>
                    
                </div>
            <?php }
        }

        public function get_post_author_info() { ?>
            <div class="pxl-post--author-info pxl-item--flexnw">
                <div class="pxl-post--author-image pxl-mr-30"><?php echo get_avatar( get_the_author_meta( 'ID' ), 280 ); ?></div>
                <div class="pxl-post--author-meta">
                    <?php aimo_get_user_name(); ?>
                    <div class="pxl-post--author-description"><?php the_author_meta( 'description' ); ?></div>
                    <?php aimo_get_user_social(); ?>
                </div>
            </div>
        <?php }

        public function get_related_post(){
            $post_related_on = aimo()->get_theme_opt( 'post_related_on', false );

            if($post_related_on) {
                global $post;
                $current_id = $post->ID;
                $posttags = get_the_category($post->ID);
                if (empty($posttags)) return;

                $tags = array();

                foreach ($posttags as $tag) {

                    $tags[] = $tag->term_id;
                }
                $post_number = '6';
                $query_similar = new WP_Query(array('posts_per_page' => $post_number, 'post_type' => 'post', 'post_status' => 'publish', 'category__in' => $tags));
                if (count($query_similar->posts) > 1) {
                    wp_enqueue_script( 'swiper' );
                    wp_enqueue_script( 'pxl-swiper' );
                    $opts = [
                        'slide_direction'               => 'horizontal',
                        'slide_percolumn'               => '1', 
                        'slide_mode'                    => 'slide', 
                        'slides_to_show'                => 3, 
                        'slides_to_show_lg'             => 3, 
                        'slides_to_show_md'             => 2, 
                        'slides_to_show_sm'             => 2, 
                        'slides_to_show_xs'             => 1, 
                        'slides_to_scroll'              => 1, 
                        'slides_gutter'                 => 30, 
                        'arrow'                         => false,
                        'dots'                          => true,
                        'dots_style'                    => 'bullets'
                    ];
                    $data_settings = wp_json_encode($opts);
                    $dir           = is_rtl() ? 'rtl' : 'ltr';
                    ?>
                    <div class="pxl-related-post">
                        <h4 class="widget-title"><?php echo esc_html__('Related Posts', 'aimo'); ?></h4>
                        <div class="class" data-settings="<?php echo esc_attr($data_settings) ?>" data-rtl="<?php echo esc_attr($dir) ?>">
                            <div class="pxl-related-post-inner pxl-swiper-wrapper swiper-wrapper">
                            <?php foreach ($query_similar->posts as $post):
                                $thumbnail_url = '';
                                if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) :
                                    $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'pxl-blog-small', false);
                                endif;
                                if ($post->ID !== $current_id) : ?>
                                    <div class="pxl-swiper-slide swiper-slide grid-item">
                                        <div class="pxl-grid-item-inner">
                                            <?php if (has_post_thumbnail()) { ?>
                                                <div class="item-featured">
                                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($thumbnail_url[0]); ?>" /></a>
                                                </div>
                                            <?php } ?>
                                            <h3 class="item-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>
                                        </div>
                                    </div>
                                <?php endif;
                            endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }

            wp_reset_postdata();
        }
    }
}
