<?php if(!function_exists('aimo_configs')){
    function aimo_configs($value){
        $primary_darker = aimo()->get_opt('primary_color', '#A234FD');
        $primary_darker_10 = pxl_darker_color($primary_darker, $primary_darker_10=1);
        $primary_darker_20 = pxl_darker_color($primary_darker, $primary_darker_20=1.3);
        $primary_darker_30 = pxl_darker_color($primary_darker, $primary_darker_30=3);
        $primary_darker_40 = pxl_darker_color($primary_darker, $primary_darker_40=4);

        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'aimo'), 
                    'value' => aimo()->get_opt('primary_color', '#A234FD')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'aimo'), 
                    'value' => aimo()->get_opt('secondary_color', '#5d00f7')
                ],
                'gradient-first'   => [
                    'title' => esc_html__('Gradient First', 'aimo'), 
                    'value' => aimo()->get_opt('gradient_first_color', '#ffa800')
                ],
                'heading'   => [
                    'title' => esc_html__('Heading', 'aimo'), 
                    'value' => aimo()->get_opt('heading_color', '#07000e')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'aimo'), 
                    'value' => aimo()->get_opt('third_color', '#FF6F05')
                ],
                'fourth'   => [
                    'title' => esc_html__('Fourth', 'aimo'), 
                    'value' => aimo()->get_opt('fourth_color', '#FF31AB')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'aimo'), 
                    'value' => aimo()->get_opt('dark_color', '#000')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'aimo'), 
                    'value' => aimo()->get_page_opt('body_bg_color', '#fff')
                ],
                'primary-darker-10'   => [
                    'title' => esc_html__('Primary Darker Color 10', 'aimo'),
                    'value' => $primary_darker_10
                ],
                'primary-darker-20'   => [
                    'title' => esc_html__('Primary Darker Color 20', 'aimo'), 
                    'value' => $primary_darker_20
                ],
                'primary-darker-30'   => [
                    'title' => esc_html__('Primary Darker Color 30', 'aimo'), 
                    'value' => $primary_darker_30
                ],
                'primary-darker-40'   => [
                    'title' => esc_html__('Primary Darker Color 40', 'aimo'), 
                    'value' => $primary_darker_40
                ]
            ],
            'link' => [
                'color' => aimo()->get_opt('link_color', ['regular' => '#6000ff'])['regular'],
                'color-hover'   => aimo()->get_opt('link_color', ['hover' => '#fe0054'])['hover'],
                'color-active'  => aimo()->get_opt('link_color', ['active' => '#fe0054'])['active'],
            ],
            'gradient' => [
                'color-from' => aimo()->get_opt('gradient_color', ['from' => '#6000ff'])['from'],
                'color-to' => aimo()->get_opt('gradient_color', ['to' => '#3d34fd'])['to'],
            ],
            'gradient2' => [
                'color-from' => aimo()->get_opt('gradient_color2', ['from' => '#f8b6bb'])['from'],
                'color-to' => aimo()->get_opt('gradient_color2', ['to' => '#b866fd'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('aimo_inline_styles')) {
    function aimo_inline_styles() {  
        
        $theme_colors      = aimo_configs('theme_colors');
        $link_color        = aimo_configs('link');
        $gradient_color    = aimo_configs('gradient');
        $gradient_color2   = aimo_configs('gradient2');

        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  aimo_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color2 as $color => $value) {
                printf('--gradient-%1$s2: %2$s;', $color, $value);
            }

        echo '}';

        return ob_get_clean();
         
    }
}
 